/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow;

import java.io.File;
import net.sf.okapi.applications.rainbow.Res;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.UserConfiguration;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.TextAndBrowsePanel;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class PreferencesForm {
    private Shell shell;
    private IHelp help;
    private Button rdStartPrjDoNotLoad;
    private Button rdStartPrjAsk;
    private Button rdStartPrjLoad;
    private Button chkAlwaysOpenLog;
    private Button chkAllowDuplicateInputs;
    private Button chkUseUserDefaults;
    private Combo cbLogLevel;
    private UserConfiguration config;
    private TextAndBrowsePanel pnlDropinsDir;
    private TextAndBrowsePanel pnlParamsDir;

    PreferencesForm(Shell p_Parent, IHelp helpParam) {
        this.help = helpParam;
        this.shell = new Shell(p_Parent, 65648);
        this.shell.setText(Res.getString("PreferencesForm.caption"));
        UIUtil.inheritIcon((Shell)this.shell, (Shell)p_Parent);
        this.shell.setLayout((Layout)new GridLayout());
        Group grpTmp = new Group((Composite)this.shell, 0);
        grpTmp.setText(Res.getString("PreferencesForm.initialProjectGroup"));
        grpTmp.setLayoutData((Object)new GridData(1808));
        grpTmp.setLayout((Layout)new GridLayout());
        this.rdStartPrjDoNotLoad = new Button((Composite)grpTmp, 16);
        this.rdStartPrjDoNotLoad.setText(Res.getString("PreferencesForm.neverLoad"));
        this.rdStartPrjAsk = new Button((Composite)grpTmp, 16);
        this.rdStartPrjAsk.setText(Res.getString("PreferencesForm.askUser"));
        this.rdStartPrjLoad = new Button((Composite)grpTmp, 16);
        this.rdStartPrjLoad.setText(Res.getString("PreferencesForm.autoLoad"));
        grpTmp = new Group((Composite)this.shell, 0);
        grpTmp.setText(Res.getString("PreferencesForm.miscGroup"));
        grpTmp.setLayoutData((Object)new GridData(1808));
        grpTmp.setLayout((Layout)new GridLayout(2, false));
        this.chkAlwaysOpenLog = new Button((Composite)grpTmp, 32);
        this.chkAlwaysOpenLog.setText(Res.getString("PreferencesForm.alwaysOpenLog"));
        GridData gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkAlwaysOpenLog.setLayoutData((Object)gdTmp);
        this.chkAllowDuplicateInputs = new Button((Composite)grpTmp, 32);
        this.chkAllowDuplicateInputs.setText(Res.getString("PreferencesForm.allowDuplicated"));
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkAllowDuplicateInputs.setLayoutData((Object)gdTmp);
        this.chkUseUserDefaults = new Button((Composite)grpTmp, 32);
        this.chkUseUserDefaults.setText(Res.getString("PreferencesForm.useUserDefaults"));
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkUseUserDefaults.setLayoutData((Object)gdTmp);
        Label label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("PreferencesForm.logLevel"));
        this.cbLogLevel = new Combo((Composite)grpTmp, 12);
        this.cbLogLevel.add(Res.getString("PreferencesForm.logNormal"));
        this.cbLogLevel.add(Res.getString("PreferencesForm.logDebug"));
        this.cbLogLevel.add(Res.getString("PreferencesForm.logTrace"));
        grpTmp = new Group((Composite)this.shell, 0);
        grpTmp.setText("Plugins Location");
        grpTmp.setLayoutData((Object)new GridData(1808));
        grpTmp.setLayout((Layout)new GridLayout(1, false));
        label = new Label((Composite)grpTmp, 0);
        label.setText("Enter the directory for the plugins (leave empty to use the default)");
        this.pnlDropinsDir = new TextAndBrowsePanel((Composite)grpTmp, 0, true);
        this.pnlDropinsDir.setTitle("Select the Plugins Location");
        gdTmp = new GridData(768);
        gdTmp.minimumWidth = 500;
        this.pnlDropinsDir.setLayoutData((Object)gdTmp);
        grpTmp = new Group((Composite)this.shell, 0);
        grpTmp.setText("Default Custom Parameters Folder");
        grpTmp.setLayoutData((Object)new GridData(1808));
        grpTmp.setLayout((Layout)new GridLayout(1, false));
        label = new Label((Composite)grpTmp, 0);
        label.setText("Enter the directory for the parameters (leave empty to use the default)");
        this.pnlParamsDir = new TextAndBrowsePanel((Composite)grpTmp, 0, true);
        this.pnlParamsDir.setTitle("Select the Parameters Location");
        gdTmp = new GridData(768);
        gdTmp.minimumWidth = 500;
        this.pnlParamsDir.setLayoutData((Object)gdTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (PreferencesForm.this.help != null) {
                        PreferencesForm.this.help.showWiki("Rainbow - User Preferences");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !PreferencesForm.this.saveData()) {
                    return;
                }
                PreferencesForm.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        pnlActions.setLayoutData((Object)gdTmp);
        this.shell.setDefaultButton(pnlActions.btOK);
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Dialogs.centerWindow((Shell)this.shell, (Shell)p_Parent);
    }

    void showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    void setData(UserConfiguration config) {
        this.config = config;
        this.chkAlwaysOpenLog.setSelection(config.getBoolean("alwaysOpenLog"));
        this.chkAllowDuplicateInputs.setSelection(config.getBoolean("allowDupInput"));
        this.chkUseUserDefaults.setSelection(config.getBoolean("useUserDefaults"));
        int n = config.getInteger("loadMRU");
        if (n == 1) {
            this.rdStartPrjAsk.setSelection(true);
        } else if (n == 2) {
            this.rdStartPrjLoad.setSelection(true);
        } else {
            this.rdStartPrjDoNotLoad.setSelection(true);
        }
        n = config.getInteger("logLevel");
        if (n < 0 || n > 2) {
            n = 0;
        }
        this.cbLogLevel.select(n);
        String tmp = config.getProperty("dropinsDir", "");
        if (tmp.endsWith("/") || tmp.endsWith("\\")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        this.pnlDropinsDir.setText(tmp);
        tmp = config.getProperty("paramsDir", "");
        if (tmp.endsWith("/") || tmp.endsWith("\\")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        this.pnlParamsDir.setText(tmp);
    }

    private boolean saveData() {
        try {
            File file;
            String tmp = this.pnlDropinsDir.getText().trim();
            if (tmp.length() > 0) {
                if (tmp.endsWith("/") || tmp.endsWith("\\")) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                }
                if (!(file = new File(tmp)).exists()) {
                    Dialogs.showError((Shell)this.shell, (String)"The directory for the plugins does not exists.", null);
                    this.pnlDropinsDir.setFocus();
                    return false;
                }
                if (!file.isDirectory()) {
                    Dialogs.showError((Shell)this.shell, (String)"The path for the plugins location is not a directory.", null);
                    this.pnlDropinsDir.setFocus();
                    return false;
                }
            }
            this.config.setProperty("dropinsDir", tmp);
            tmp = this.pnlParamsDir.getText().trim();
            if (tmp.length() > 0) {
                if (tmp.endsWith("/") || tmp.endsWith("\\")) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                }
                if (!(file = new File(tmp)).exists()) {
                    Dialogs.showError((Shell)this.shell, (String)"The directory for the parameters does not exists.", null);
                    this.pnlParamsDir.setFocus();
                    return false;
                }
                if (!file.isDirectory()) {
                    Dialogs.showError((Shell)this.shell, (String)"The path for the parameters location is not a directory.", null);
                    this.pnlParamsDir.setFocus();
                    return false;
                }
            }
            this.config.setProperty("paramsDir", tmp);
            this.config.setProperty("alwaysOpenLog", this.chkAlwaysOpenLog.getSelection());
            this.config.setProperty("allowDupInput", this.chkAllowDuplicateInputs.getSelection());
            this.config.setProperty("useUserDefaults", this.chkUseUserDefaults.getSelection());
            if (this.rdStartPrjAsk.getSelection()) {
                this.config.setProperty("loadMRU", 1);
            } else if (this.rdStartPrjLoad.getSelection()) {
                this.config.setProperty("loadMRU", 2);
            } else {
                this.config.setProperty("loadMRU", 0);
            }
            this.config.setProperty("logLevel", this.cbLogLevel.getSelectionIndex());
        }
        catch (Exception E) {
            return false;
        }
        return true;
    }
}

