/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.ClosePanel;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CodeFinderEditor {
    private Shell shell;
    private IHelp help;
    private Button btCopyToClipboard;
    private Button chkXMLAware;
    private Button chkYAMLAware;
    private InlineCodeFinderPanel pnlCodeFinder;

    public CodeFinderEditor(Shell p_Parent, IHelp helpParam) {
        this.help = helpParam;
        this.shell = new Shell(p_Parent, 65648);
        this.shell.setText("Code Finder Editor");
        UIUtil.inheritIcon((Shell)this.shell, (Shell)p_Parent);
        this.shell.setLayout((Layout)new GridLayout(4, false));
        this.pnlCodeFinder = new InlineCodeFinderPanel((Composite)this.shell, 0);
        GridData gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 4;
        this.pnlCodeFinder.setLayoutData((Object)gdTmp);
        this.chkXMLAware = new Button((Composite)this.shell, 32);
        this.chkXMLAware.setText("XML aware");
        this.chkXMLAware.setLayoutData((Object)new GridData(640));
        this.chkYAMLAware = new Button((Composite)this.shell, 32);
        this.chkYAMLAware.setText("YAML aware");
        this.chkYAMLAware.setLayoutData((Object)new GridData(128));
        int width = 170;
        this.btCopyToClipboard = new Button((Composite)this.shell, 8);
        this.btCopyToClipboard.setText("Paste From Clipboard");
        gdTmp = new GridData(128);
        gdTmp.widthHint = 170;
        this.btCopyToClipboard.setLayoutData((Object)gdTmp);
        this.btCopyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeFinderEditor.this.pasteFromClipboard();
            }
        });
        this.btCopyToClipboard = new Button((Composite)this.shell, 8);
        this.btCopyToClipboard.setText("Copy To Clipboard");
        gdTmp = new GridData(128);
        gdTmp.widthHint = 170;
        this.btCopyToClipboard.setLayoutData((Object)gdTmp);
        this.btCopyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeFinderEditor.this.copyToClipboard();
            }
        });
        SelectionAdapter CloseActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (CodeFinderEditor.this.help != null) {
                        CodeFinderEditor.this.help.showWiki("Rainbow - Code Finder Editor");
                    }
                    return;
                }
                CodeFinderEditor.this.shell.close();
            }
        };
        ClosePanel pnlActions = new ClosePanel((Composite)this.shell, 0, CloseActions, this.help != null);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        pnlActions.setLayoutData((Object)gdTmp);
        this.shell.setDefaultButton(pnlActions.btClose);
        this.shell.pack();
        Rectangle rect = this.shell.getBounds();
        this.shell.setMinimumSize(rect.width, rect.height);
        if (rect.width < 700) {
            rect.width = 700;
        }
        if (rect.height < 450) {
            rect.height = 450;
        }
        this.shell.setSize(rect.width, rect.height);
        Dialogs.centerWindow((Shell)this.shell, (Shell)p_Parent);
        this.setInitialRules();
    }

    public void showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void setInitialRules() {
        this.chkXMLAware.setSelection(true);
        this.pnlCodeFinder.setRules("#v1\ncount.i=1\nrule0=(\\A[^<]*?>)|(<[\\w!?/].*?(>|\\Z))\nsample=Text <b>bold</b> <a name=\"abc\">\nuseAllRulesWhenTesting.b=false");
        this.pnlCodeFinder.updateDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToClipboard() {
        Clipboard clipboard = null;
        try {
            String text = this.pnlCodeFinder.getRules();
            if (text == null) {
                Dialogs.showError((Shell)this.shell, (String)"Error in expression.\nNo data copied.", null);
            }
            if (this.chkXMLAware.getSelection()) {
                text = Util.escapeToXML((String)text, (int)1, (boolean)false, null);
            }
            if (this.chkYAMLAware.getSelection()) {
                text = this.escapeToYAML(text);
            }
            clipboard = new Clipboard(this.shell.getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipboard.setContents((Object[])new String[]{text}, new Transfer[]{textTransfer});
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.shell, (String)e.getLocalizedMessage(), null);
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pasteFromClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.shell.getDisplay());
            TransferData[] transferDatas = clipboard.getAvailableTypes();
            boolean found = false;
            for (int i = 0; i < transferDatas.length; ++i) {
                if (!TextTransfer.getInstance().isSupportedType(transferDatas[i])) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (this.chkXMLAware.getSelection()) {
                text = this.unescapeFromXML(text);
            }
            if (this.chkYAMLAware.getSelection()) {
                text = this.unescapeFromYAML(text);
            }
            this.pnlCodeFinder.setRules(text);
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.shell, (String)e.getLocalizedMessage(), null);
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
            this.pnlCodeFinder.updateDisplay();
        }
    }

    private String unescapeFromXML(String text) {
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        text = text.replace("&apos;", "'");
        return text.replace("&amp;", "&");
    }

    private String escapeToYAML(String text) {
        text = text.replace("\\", "\\\\");
        text = text.replace("\"", "\\\"");
        return text.replace("\n", "\\n");
    }

    private String unescapeFromYAML(String text) {
        text = text.replaceAll("([^\\\\])\\\\n", "$1\n");
        text = text.replaceAll("\\\\\\\"", "\"");
        return text.replace("\\\\", "\\");
    }
}

