/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import net.sf.okapi.applications.rainbow.Project;
import net.sf.okapi.applications.rainbow.lib.Res;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDialog;
import net.sf.okapi.common.ui.filters.FilterConfigurationsDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CustomConfigurationFolderPanel
extends Composite {
    private Text edParamsFolder;
    private Button btGetParamsFolder;
    private Project project;
    private FilterConfigurationsDialog dialog;

    public CustomConfigurationFolderPanel(Composite parent, int style, Project project, FilterConfigurationsDialog dialog) {
        super(parent, style);
        this.dialog = dialog;
        this.project = project;
        this.createContent();
    }

    private void createContent() {
        GridLayout layTmp = new GridLayout(1, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout((Layout)layTmp);
        Group group = new Group((Composite)this, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(Res.getString("CustomConfigurationFolderPanel.caption"));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(Res.getString("CustomConfigurationFolderPanel.folder"));
        this.edParamsFolder = new Text((Composite)group, 2048);
        this.edParamsFolder.setLayoutData((Object)new GridData(768));
        this.edParamsFolder.setEditable(false);
        this.btGetParamsFolder = new Button((Composite)group, 8);
        this.btGetParamsFolder.setText("...");
        this.btGetParamsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CustomConfigurationFolderPanel.this.editParamsFolder();
            }
        });
        this.edParamsFolder.setText(this.project.getParametersFolder(true));
    }

    private void editParamsFolder() {
        try {
            InputDialog dlg = new InputDialog(this.getShell(), Res.getString("CustomConfigurationFolderPanel.customConfigCaption"), Res.getString("CustomConfigurationFolderPanel.customConfigCaptionLabel"), this.project.getParametersFolder(true, false), null, 1, -1, -1);
            dlg.setAllowEmptyValue(true);
            String newDir = dlg.showDialog();
            if (newDir == null) {
                return;
            }
            if (newDir.length() < 2) {
                newDir = "";
            }
            this.project.setCustomParametersFolder(newDir);
            this.project.setUseCustomParametersFolder(newDir.length() != 0);
            this.edParamsFolder.setText(this.project.getParametersFolder(true));
            if (this.dialog != null) {
                this.dialog.updateCustomConfigurations();
            }
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.getShell(), (String)e.getMessage(), null);
        }
    }
}

