/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import com.ibm.icu.impl.LocaleIDs;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.okapi.applications.rainbow.lib.LanguageItem;

public class LanguageManager {
    private final List<LanguageItem> langs = Collections.unmodifiableList(this.initialize());

    private static ULocale removeTheScript(ULocale loc) {
        ULocale locNoScript;
        ULocale fullLocale;
        String script = loc.getScript();
        if (!script.isEmpty() && script.equals((fullLocale = ULocale.addLikelySubtags((ULocale)(locNoScript = new ULocale.Builder().setLocale(loc).setScript("").build()))).getScript())) {
            return locNoScript;
        }
        return loc;
    }

    private boolean addLocale(Set<ULocale> allLocales, ULocale loc) {
        if (allLocales.contains(loc)) {
            return false;
        }
        String lang = loc.getLanguage();
        if (lang.isEmpty()) {
            return false;
        }
        if ("zxx".equals(lang)) {
            return false;
        }
        if ("ZZ".equals(loc.getCountry())) {
            return false;
        }
        if (lang.equals(loc.getDisplayLanguage(ULocale.US))) {
            return false;
        }
        allLocales.add(loc);
        return true;
    }

    private List<LanguageItem> initialize() {
        ULocale fullLocale;
        TreeSet<ULocale> allLocales = new TreeSet<ULocale>();
        for (ULocale uLocale : ULocale.getAvailableLocales()) {
            this.addLocale(allLocales, uLocale);
            this.addLocale(allLocales, LanguageManager.removeTheScript(uLocale));
        }
        for (String string : LocaleIDs.getISOLanguages()) {
            ULocale loc2 = ULocale.forLanguageTag((String)string);
            fullLocale = ULocale.addLikelySubtags((ULocale)loc2);
            this.addLocale(allLocales, loc2);
            this.addLocale(allLocales, LanguageManager.removeTheScript(fullLocale));
        }
        for (String string : LocaleIDs.getISOCountries()) {
            ULocale loc2 = ULocale.forLanguageTag((String)("und-" + string));
            fullLocale = ULocale.addLikelySubtags((ULocale)loc2);
            this.addLocale(allLocales, LanguageManager.removeTheScript(fullLocale));
        }
        ArrayList<LanguageItem> arrayList = new ArrayList<LanguageItem>();
        allLocales.forEach(loc -> result.add(new LanguageItem(loc.toLanguageTag(), loc.getDisplayName(ULocale.US))));
        Collections.sort(arrayList, (a, b) -> a.toString().compareTo(b.toString()));
        return arrayList;
    }

    public int getCount() {
        return this.langs.size();
    }

    public LanguageItem getItem(int p_nIndex) {
        return this.langs.get(p_nIndex);
    }

    public LanguageItem GetItem(String p_sCode) {
        for (int i = 0; i < this.langs.size(); ++i) {
            if (!p_sCode.equalsIgnoreCase(this.langs.get((int)i).code)) continue;
            return this.langs.get(i);
        }
        return null;
    }

    public String GetNameFromCode(String p_sCode) {
        for (int i = 0; i < this.langs.size(); ++i) {
            if (!p_sCode.equalsIgnoreCase(this.langs.get((int)i).code)) continue;
            return this.langs.get((int)i).name;
        }
        return p_sCode;
    }

    public int getIndexFromCode(String p_sCode) {
        if (p_sCode == null) {
            return -1;
        }
        for (int i = 0; i < this.langs.size(); ++i) {
            if (!p_sCode.equalsIgnoreCase(this.langs.get((int)i).code)) continue;
            return i;
        }
        return -1;
    }
}

