/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import net.sf.okapi.applications.rainbow.lib.Res;
import net.sf.okapi.applications.rainbow.lib.Utils;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.lib.ui.segmentation.SRXEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SegmentationPanel
extends Composite {
    private Button chkSegment;
    private Label stSourceSRX;
    private Text edSourceSRX;
    private Button btGetSourceSRX;
    private Button btEditSourceSRX;
    private Label stTargetSRX;
    private Text edTargetSRX;
    private Button btGetTargetSRX;
    private Button btEditTargetSRX;
    private IHelp help;
    private String projectDir;

    public SegmentationPanel(Composite p_Parent, int p_nFlags, String segmentCaption, IHelp helpParam, String projectDir) {
        super(p_Parent, 0);
        this.help = helpParam;
        this.projectDir = projectDir;
        this.createContent(segmentCaption);
    }

    private void createContent(String segmentCaption) {
        GridLayout layTmp = new GridLayout(4, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout((Layout)layTmp);
        this.chkSegment = new Button((Composite)this, 32);
        this.chkSegment.setText(segmentCaption);
        GridData gdTmp = new GridData();
        gdTmp.horizontalSpan = 4;
        this.chkSegment.setLayoutData((Object)gdTmp);
        this.chkSegment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SegmentationPanel.this.updateDisplay();
            }
        });
        this.stSourceSRX = new Label((Composite)this, 0);
        this.stSourceSRX.setText(Res.getString("SegmentationPanel.sourceSrx"));
        this.edSourceSRX = new Text((Composite)this, 2048);
        this.edSourceSRX.setLayoutData((Object)new GridData(768));
        this.btGetSourceSRX = new Button((Composite)this, 8);
        this.btGetSourceSRX.setText("...");
        this.btGetSourceSRX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SegmentationPanel.this.getSRXFile(SegmentationPanel.this.edSourceSRX);
            }
        });
        this.btEditSourceSRX = new Button((Composite)this, 8);
        this.btEditSourceSRX.setText(Res.getString("SegmentationPanel.edit"));
        this.btEditSourceSRX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SegmentationPanel.this.editSRXFile(SegmentationPanel.this.edSourceSRX);
            }
        });
        this.stTargetSRX = new Label((Composite)this, 0);
        this.stTargetSRX.setText(Res.getString("SegmentationPanel.targetSrx"));
        this.edTargetSRX = new Text((Composite)this, 2048);
        this.edTargetSRX.setLayoutData((Object)new GridData(768));
        this.btGetTargetSRX = new Button((Composite)this, 8);
        this.btGetTargetSRX.setText("...");
        this.btGetTargetSRX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SegmentationPanel.this.getSRXFile(SegmentationPanel.this.edTargetSRX);
            }
        });
        this.btEditTargetSRX = new Button((Composite)this, 8);
        this.btEditTargetSRX.setText(Res.getString("SegmentationPanel.edit"));
        this.btEditTargetSRX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SegmentationPanel.this.editSRXFile(SegmentationPanel.this.edTargetSRX);
            }
        });
    }

    private void getSRXFile(Text edTextField) {
        String caption = edTextField == this.edSourceSRX ? Res.getString("SegmentationPanel.selectSourceSrx") : Res.getString("SegmentationPanel.selectTargetSrx");
        String[] paths = Dialogs.browseFilenames((Shell)this.getShell(), (String)caption, (boolean)false, null, (String)Res.getString("SegmentationPanel.srxFilterDescriptions"), (String)Res.getString("SegmentationPanel.srxFilterExtensions"));
        if (paths == null) {
            return;
        }
        Utils.checkProjectDirAfterPick(paths[0], edTextField, this.projectDir);
    }

    private void editSRXFile(Text edTextField) {
        try {
            SRXEditor editor = new SRXEditor(this.getShell(), true, this.help);
            String oriPath = edTextField.getText().replace("${ProjDir}", this.projectDir);
            if (oriPath.length() == 0) {
                oriPath = null;
            }
            editor.showDialog(oriPath);
            String newPath = editor.getPath();
            Utils.checkProjectDirAfterPick(newPath, edTextField, this.projectDir);
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.getShell(), (String)e.getMessage(), null);
        }
    }

    private void updateDisplay() {
        boolean enabled = this.chkSegment.getSelection();
        this.stSourceSRX.setEnabled(enabled);
        this.edSourceSRX.setEnabled(enabled);
        this.btGetSourceSRX.setEnabled(enabled);
        this.btEditSourceSRX.setEnabled(enabled);
        this.stTargetSRX.setEnabled(enabled);
        this.edTargetSRX.setEnabled(enabled);
        this.btGetTargetSRX.setEnabled(enabled);
        this.btEditTargetSRX.setEnabled(enabled);
    }

    public void setData(boolean segment, String sourceSRX, String targetSRX) {
        this.chkSegment.setSelection(segment);
        this.edSourceSRX.setText(sourceSRX);
        this.edTargetSRX.setText(targetSRX);
        this.updateDisplay();
    }

    public boolean validate() {
        if (!this.chkSegment.getSelection()) {
            return true;
        }
        if (this.edSourceSRX.getText().trim().length() == 0) {
            Dialogs.showError((Shell)this.getShell(), (String)"You must specify an SRX document for the source.", null);
            this.edSourceSRX.setFocus();
            return false;
        }
        return true;
    }

    public boolean getSegment() {
        return this.chkSegment.getSelection();
    }

    public String getSourceSRX() {
        return this.edSourceSRX.getText();
    }

    public String getTargetSRX() {
        return this.edTargetSRX.getText();
    }
}

