/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.packages.xliff;

import java.io.File;
import net.sf.okapi.applications.rainbow.packages.BaseWriter;
import net.sf.okapi.applications.rainbow.packages.xliff.Options;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class Writer
extends BaseWriter {
    private static final String EXTENSION = ".xlf";
    private static final String RESTYPEVALUES = ";auto3state;autocheckbox;autoradiobutton;bedit;bitmap;button;caption;cell;checkbox;checkboxmenuitem;checkedlistbox;colorchooser;combobox;comboboxexitem;comboboxitem;component;contextmenu;ctext;cursor;datetimepicker;defpushbutton;dialog;dlginit;edit;file;filechooser;fn;font;footer;frame;grid;groupbox;header;heading;hedit;hscrollbar;icon;iedit;keywords;label;linklabel;list;listbox;listitem;ltext;menu;menubar;menuitem;menuseparator;message;monthcalendar;numericupdown;panel;popupmenu;pushbox;pushbutton;radio;radiobuttonmenuitem;rcdata;row;rtext;scrollpane;separator;shortcut;spinner;splitter;state3;statusbar;string;tabcontrol;table;textbox;togglebutton;toolbar;tooltip;trackbar;tree;uri;userbutton;usercontrol;var;versioninfo;vscrollbar;window;";
    protected Options options = new Options();
    private XMLWriter writer = null;
    private final XLIFFContent xliffCont = new XLIFFContent();
    private boolean useSourceForTranslated = false;
    private boolean inFile;
    private LocaleId srcLang;
    private String docMimeType;

    @Override
    public String getPackageType() {
        return "xliff";
    }

    @Override
    public String getReaderClass() {
        return "net.sf.okapi.applications.rainbow.packages.xliff.Reader";
    }

    @Override
    public void writeStartPackage() {
        String tmp = this.manifest.getSourceLocation();
        if (tmp == null || tmp.length() == 0) {
            this.manifest.setSourceLocation("work");
        }
        if ((tmp = this.manifest.getTargetLocation()) == null || tmp.length() == 0) {
            this.manifest.setTargetLocation("work");
        }
        if ((tmp = this.manifest.getOriginalLocation()) == null || tmp.length() == 0) {
            this.manifest.setOriginalLocation("original");
        }
        if (tmp == null || tmp.length() == 0) {
            this.manifest.setDoneLocation("done");
        }
        super.writeStartPackage();
    }

    @Override
    public void createOutput(int docID, String relativeSourcePath, String relativeTargetPath, String sourceEncoding, String targetEncoding, String filtersettings, IParameters filterParams, EncoderManager encoderManager) {
        this.encoderManager = encoderManager;
        this.relativeWorkPath = relativeSourcePath;
        if (this.manifest.getPackageType().equals("omegat")) {
            this.relativeWorkPath = String.format("%d.%s", docID, Util.getFilename((String)relativeSourcePath, (boolean)true));
            this.options.setIncludeNoTranslate(false);
            this.options.setCopySource(true);
            this.options.setIncludeAltTrans(false);
            this.useSourceForTranslated = true;
        }
        this.relativeWorkPath = this.relativeWorkPath + EXTENSION;
        super.createOutput(docID, relativeSourcePath, relativeTargetPath, sourceEncoding, targetEncoding, filtersettings, filterParams);
        this.close();
        this.writer = new XMLWriter(this.manifest.getRoot() + File.separator + (String)(this.manifest.getSourceLocation().length() == 0 ? "" : this.manifest.getSourceLocation() + File.separator) + this.relativeWorkPath);
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public String getName() {
        return this.getClass().getName();
    }

    public EncoderManager getEncoderManager() {
        return null;
    }

    public Options getParameters() {
        return this.options;
    }

    public void setParameters(IParameters params) {
        this.options = (Options)params;
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                this.close();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument((StartSubDocument)event.getResource());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument((Ending)event.getResource());
                break;
            }
            case START_GROUP: 
            case START_SUBFILTER: {
                this.processStartGroup((StartGroup)event.getResource());
                break;
            }
            case END_GROUP: 
            case END_SUBFILTER: {
                this.processEndGroup((Ending)event.getResource());
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
                break;
            }
        }
        return event;
    }

    private void processStartDocument(StartDocument resource) {
        this.srcLang = resource.getLocale();
        this.writer.writeStartDocument();
        this.writer.writeStartElement("xliff");
        this.writer.writeAttributeString("version", "1.2");
        this.writer.writeAttributeString("xmlns", "urn:oasis:names:tc:xliff:document:1.2");
        this.writer.writeAttributeString("xmlns:okp", "okapi-framework:xliff-extensions");
        this.docMimeType = resource.getMimeType();
        if (this.options.getMessage() != null && this.options.getMessage().length() > 0) {
            this.writer.writeComment(this.options.getMessage(), true);
        }
    }

    private void processEndDocument() {
        if (this.inFile) {
            this.writeEndFile();
        }
        this.writer.writeEndElementLineBreak();
        this.writer.writeEndDocument();
        this.close();
        this.manifest.addDocument(this.docID, this.relativeWorkPath, this.relativeSourcePath, this.relativeTargetPath, this.sourceEncoding, this.targetEncoding, this.filterID, "default");
    }

    private void processStartSubDocument(StartSubDocument resource) {
        this.writeStartFile(resource.getName(), resource.getMimeType());
    }

    private void writeStartFile(String original, String contentType) {
        this.writer.writeLineBreak();
        this.writer.writeStartElement("file");
        this.writer.writeAttributeString("original", original != null ? original : "unknown");
        this.writer.writeAttributeString("source-language", this.srcLang.toBCP47());
        this.writer.writeAttributeString("target-language", this.trgLoc.toBCP47());
        contentType = contentType == null ? "x-undefined" : (((String)contentType).equals("text/html") ? "html" : (((String)contentType).equals("text/xml") ? "xml" : "x-" + (String)contentType));
        this.writer.writeAttributeString("datatype", (String)contentType);
        this.writer.writeLineBreak();
        this.inFile = true;
        this.writer.writeStartElement("body");
        this.writer.writeLineBreak();
    }

    private void processEndSubDocument(Ending resource) {
        this.writeEndFile();
    }

    private void writeEndFile() {
        this.writer.writeEndElementLineBreak();
        this.writer.writeEndElementLineBreak();
        this.inFile = false;
    }

    private void processStartGroup(StartGroup resource) {
        if (!this.inFile) {
            this.writeStartFile(this.relativeSourcePath, this.docMimeType);
        }
        this.writer.writeStartElement("group");
        this.writer.writeAttributeString("id", resource.getId());
        String tmp = resource.getName();
        if (tmp != null && tmp.length() != 0) {
            this.writer.writeAttributeString("resname", tmp);
        }
        if (!Util.isEmpty((String)(tmp = resource.getType()))) {
            if (tmp.startsWith("x-") || RESTYPEVALUES.contains(";" + tmp + ";")) {
                this.writer.writeAttributeString("restype", tmp);
            } else {
                this.writer.writeAttributeString("restype", "x-" + tmp);
            }
        }
        this.writer.writeLineBreak();
    }

    private void processEndGroup(Ending resource) {
        this.writer.writeEndElementLineBreak();
    }

    private void processTextUnit(ITextUnit tu) {
        Property prop;
        if (this.options.getSetApprovedAsNoTranslate() && (prop = tu.getTargetProperty(this.trgLoc, "approved")) != null && prop.getValue().equals("yes")) {
            tu.setIsTranslatable(false);
        }
        if (!this.options.getIncludeNoTranslate() && !tu.isTranslatable()) {
            return;
        }
        if (!this.inFile) {
            this.writeStartFile(this.relativeSourcePath, this.docMimeType);
        }
        this.writer.writeStartElement("trans-unit");
        this.writer.writeAttributeString("id", String.valueOf(tu.getId()));
        String tmp = tu.getName();
        if (tmp != null && tmp.length() != 0) {
            this.writer.writeAttributeString("resname", tmp);
        }
        if (!Util.isEmpty((String)(tmp = tu.getType()))) {
            if (tmp.startsWith("x-") || RESTYPEVALUES.contains(";" + tmp + ";")) {
                this.writer.writeAttributeString("restype", tmp);
            } else {
                this.writer.writeAttributeString("restype", "x-" + tmp);
            }
        }
        if (!tu.isTranslatable()) {
            this.writer.writeAttributeString("translate", "no");
        }
        if (tu.hasTargetProperty(this.trgLoc, "approved") && tu.getTargetProperty(this.trgLoc, "approved").getValue().equals("yes")) {
            this.writer.writeAttributeString("approved", "yes");
        }
        if (tu.preserveWhitespaces()) {
            this.writer.writeAttributeString("xml:space", "preserve");
        }
        this.writer.writeLineBreak();
        TextContainer tc = tu.getSource();
        boolean srcHasText = tc.hasText(false);
        this.writer.writeStartElement("source");
        this.writer.writeAttributeString("xml:lang", this.manifest.getSourceLanguage().toBCP47());
        this.writer.writeRawXML(this.xliffCont.toSegmentedString(tc, 0, false, false, this.options.getGMode(), false, true, false, this.manifest.getTargetLanguage()));
        this.writer.writeEndElementLineBreak();
        if (tc.hasBeenSegmented()) {
            this.writer.writeStartElement("seg-source");
            this.writer.writeRawXML(this.xliffCont.toSegmentedString(tc, 0, false, true, this.options.getGMode(), false, true, false, this.manifest.getTargetLanguage()));
            this.writer.writeEndElementLineBreak();
        }
        this.writer.writeStartElement("target");
        this.writer.writeAttributeString("xml:lang", this.manifest.getTargetLanguage().toBCP47());
        tc = tu.getTarget(this.trgLoc);
        if (this.useSourceForTranslated || tc == null || tc.isEmpty() || srcHasText && !tc.hasText(false)) {
            tc = tu.getSource();
            if (!this.options.getCopySource()) {
                tc.clear();
            }
        }
        super.writeTMXEntries(tu);
        this.writer.writeRawXML(this.xliffCont.toSegmentedString(tc, 0, false, tc.hasBeenSegmented(), this.options.getGMode(), false, true, true, this.manifest.getTargetLanguage()));
        this.writer.writeEndElementLineBreak();
        NoteAnnotation notes = (NoteAnnotation)tu.getAnnotation(NoteAnnotation.class);
        if (notes != null) {
            for (Note n : notes) {
                this.writer.writeStartElement("note");
                if (n.getAnnotates() != null) {
                    this.writer.writeAttributeString("annotates", n.getAnnotates().toString());
                }
                if (n.getFrom() != null) {
                    this.writer.writeAttributeString("from", n.getFrom());
                }
                if (n.getPriority() != null) {
                    this.writer.writeAttributeString("priority", n.getPriority().toString());
                }
                this.writer.writeString(n.getNoteText());
                this.writer.writeEndElementLineBreak();
            }
        }
        if (this.options.getIncludeAltTrans() && (tc = tu.getTarget(this.trgLoc)) != null) {
            this.writeAlternates((AltTranslationsAnnotation)tc.getAnnotation(AltTranslationsAnnotation.class), null);
            for (Segment seg : tc.getSegments()) {
                this.writeAlternates((AltTranslationsAnnotation)seg.getAnnotation(AltTranslationsAnnotation.class), seg);
            }
        }
        this.writer.writeEndElementLineBreak();
    }

    private void writeAlternates(AltTranslationsAnnotation atAnn, Segment seg) {
        if (atAnn == null) {
            return;
        }
        for (AltTranslation at : atAnn) {
            this.writer.writeStartElement("alt-trans");
            if (seg != null) {
                this.writer.writeAttributeString("mid", seg.id);
            }
            if (at.getCombinedScore() > 0) {
                this.writer.writeAttributeString("match-quality", at.getCombinedScore() + "%");
            }
            if (!Util.isEmpty((String)at.getOrigin())) {
                this.writer.writeAttributeString("origin", at.getOrigin());
            }
            if (at.getType() != MatchType.UKNOWN) {
                this.writer.writeAttributeString("okp:matchType", at.getType().toString());
            }
            this.writer.writeLineBreak();
            TextContainer cont = at.getSource();
            if (!cont.isEmpty()) {
                this.writer.writeStartElement("source");
                this.writer.writeAttributeString("xml:lang", at.getSourceLocale().toBCP47());
                this.writer.writeRawXML(this.xliffCont.toSegmentedString(cont, 0, false, false, this.options.getGMode(), false, true, false, this.manifest.getTargetLanguage()));
                this.writer.writeEndElementLineBreak();
            }
            this.writer.writeStartElement("target");
            this.writer.writeAttributeString("xml:lang", at.getTargetLocale().toBCP47());
            cont = at.getTarget();
            this.writer.writeRawXML(this.xliffCont.toSegmentedString(cont, 0, false, false, this.options.getGMode(), false, true, true, this.manifest.getTargetLanguage()));
            this.writer.writeEndElementLineBreak();
            this.writer.writeEndElementLineBreak();
        }
    }

    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }
}

