/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.pipeline;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.applications.rainbow.pipeline.StepInfo;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineReader;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.IPipelineWriter;
import net.sf.okapi.common.pipeline.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PipelineStorage
implements IPipelineWriter,
IPipelineReader {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String path;
    private StringWriter strWriter;
    private CharSequence inputData;
    private final Map<String, StepInfo> availableSteps;

    public PipelineStorage(Map<String, StepInfo> availableSteps) {
        this.availableSteps = availableSteps;
        this.path = null;
    }

    public PipelineStorage(Map<String, StepInfo> availableSteps, String path) {
        this.availableSteps = availableSteps;
        this.path = path;
    }

    public PipelineStorage(Map<String, StepInfo> availableSteps, CharSequence inputData) {
        this.availableSteps = availableSteps;
        this.inputData = inputData;
    }

    public String getStringOutput() {
        return this.strWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IPipeline pipeline) {
        XMLWriter writer = null;
        try {
            if (this.path == null) {
                this.strWriter = new StringWriter();
                writer = new XMLWriter((Writer)this.strWriter);
                writer.setLineBreak("\n");
            } else {
                writer = new XMLWriter(this.path);
            }
            writer.writeStartDocument();
            writer.writeStartElement("rainbowPipeline");
            writer.writeAttributeString("version", "1");
            for (IPipelineStep step : pipeline.getSteps()) {
                writer.writeStartElement("step");
                writer.writeAttributeString("class", step.getClass().getName());
                IParameters params = step.getParameters();
                if (params != null) {
                    writer.writeString(params.toString());
                }
                writer.writeEndElementLineBreak();
            }
        }
        finally {
            if (writer != null) {
                writer.writeEndElementLineBreak();
                writer.writeEndDocument();
                writer.close();
            }
        }
    }

    public IPipeline read() {
        try {
            Document doc;
            DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
            Fact.setValidating(false);
            if (this.path == null) {
                InputSource is = new InputSource(new StringReader(this.inputData.toString()));
                doc = Fact.newDocumentBuilder().parse(is);
            } else {
                doc = Fact.newDocumentBuilder().parse(new File(this.path));
            }
            NodeList nodes = doc.getElementsByTagName("step");
            Pipeline pipeline = new Pipeline();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node elem = nodes.item(i);
                Node node = elem.getAttributes().getNamedItem("class");
                if (node == null) {
                    throw new OkapiException("The attribute 'class' is missing.");
                }
                String className = node.getNodeValue();
                StepInfo stepInfo = this.availableSteps.get(className);
                if (stepInfo == null) {
                    this.LOGGER.warn(String.format("The step '%s' is not among the steps currently available. It will be removed from the loaded pipeline.", className));
                    continue;
                }
                IPipelineStep step = stepInfo.loader == null ? (IPipelineStep)Class.forName(stepInfo.stepClass).newInstance() : (IPipelineStep)Class.forName(stepInfo.stepClass, true, stepInfo.loader).newInstance();
                IParameters params = step.getParameters();
                if (params != null) {
                    params.fromString(Util.getTextContent((Node)elem));
                }
                pipeline.addStep(step);
            }
            return pipeline;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | ParserConfigurationException | DOMException | SAXException e) {
            throw new OkapiException((Throwable)e);
        }
    }
}

