/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.merging;

import net.sf.okapi.applications.rainbow.packages.Manifest;
import net.sf.okapi.applications.rainbow.utilities.merging.ManifestTableModel;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ManifestDialog {
    private Shell shell;
    private IHelp help;
    private Manifest manifest;
    private ManifestTableModel tableMod;
    private SelectionAdapter CloseActions;
    private boolean result = false;
    private Text edPkgType;
    private Text edPkgID;
    private Text edSource;
    private Text edTarget;
    private Text edDate;
    private Text edMergeInputRoot;
    private Button chkUseApprovedOnly;
    private Button chkUpdateApprovedFlag;

    public ManifestDialog(Shell parent, IHelp helpParam) {
        this.help = helpParam;
        this.shell = new Shell(parent, 65648);
        this.shell.setText("Translation Package Manifest");
        UIUtil.inheritIcon((Shell)this.shell, (Shell)parent);
        this.shell.setLayout((Layout)new GridLayout());
        TabFolder tfTmp = new TabFolder((Composite)this.shell, 0);
        tfTmp.setLayoutData((Object)new GridData(1808));
        Composite cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Documents");
        tiTmp.setControl((Control)cmpTmp);
        Table tableDocs = new Table(cmpTmp, 68130);
        GridData gdTmp = new GridData(1808);
        gdTmp.minimumHeight = 300;
        gdTmp.minimumWidth = 550;
        tableDocs.setLayoutData((Object)gdTmp);
        tableDocs.setHeaderVisible(true);
        tableDocs.setLinesVisible(true);
        this.tableMod = new ManifestTableModel();
        this.tableMod.linkTable(tableDocs);
        this.edMergeInputRoot = new Text(cmpTmp, 2048);
        this.edMergeInputRoot.setLayoutData((Object)new GridData(768));
        this.edMergeInputRoot.setEditable(false);
        cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Options");
        tiTmp.setControl((Control)cmpTmp);
        this.chkUseApprovedOnly = new Button(cmpTmp, 32);
        this.chkUseApprovedOnly.setText("Merge the translation only if it is approved");
        this.chkUpdateApprovedFlag = new Button(cmpTmp, 32);
        this.chkUpdateApprovedFlag.setText("Set the 'approved' flag on the merged translations");
        cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout(2, false));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Information");
        tiTmp.setControl((Control)cmpTmp);
        Label stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Package type:");
        stTmp.setLayoutData((Object)new GridData());
        this.edPkgType = new Text(cmpTmp, 2048);
        this.edPkgType.setLayoutData((Object)new GridData(768));
        this.edPkgType.setEditable(false);
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Package ID:");
        stTmp.setLayoutData((Object)new GridData());
        this.edPkgID = new Text(cmpTmp, 2048);
        this.edPkgID.setLayoutData((Object)new GridData(768));
        this.edPkgID.setEditable(false);
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Source language:");
        stTmp.setLayoutData((Object)new GridData());
        this.edSource = new Text(cmpTmp, 2048);
        this.edSource.setLayoutData((Object)new GridData(768));
        this.edSource.setEditable(false);
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Target language:");
        stTmp.setLayoutData((Object)new GridData());
        this.edTarget = new Text(cmpTmp, 2048);
        this.edTarget.setLayoutData((Object)new GridData(768));
        this.edTarget.setEditable(false);
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Creation date:");
        stTmp.setLayoutData((Object)new GridData());
        this.edDate = new Text(cmpTmp, 2048);
        this.edDate.setLayoutData((Object)new GridData(768));
        this.edDate.setEditable(false);
        this.CloseActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (ManifestDialog.this.help != null) {
                        ManifestDialog.this.help.showWiki("Rainbow - Translation Package Manifest");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    ManifestDialog.this.tableMod.saveData();
                    ManifestDialog.this.manifest.setUseApprovedOnly(ManifestDialog.this.chkUseApprovedOnly.getSelection());
                    ManifestDialog.this.manifest.setUpdateApprovedFlag(ManifestDialog.this.chkUpdateApprovedFlag.getSelection());
                    ManifestDialog.this.result = true;
                }
                ManifestDialog.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, this.CloseActions, this.help != null, "Execute");
        pnlActions.setLayoutData((Object)new GridData(768));
        this.shell.setDefaultButton(pnlActions.btOK);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 450) {
            startSize.x = 450;
        }
        this.shell.setSize(startSize);
        Rectangle rect = tableDocs.getClientArea();
        int nPart = rect.width / 100;
        tableDocs.getColumn(0).setWidth(45 * nPart);
        tableDocs.getColumn(1).setWidth(15 * nPart);
        tableDocs.getColumn(2).setWidth(rect.width - 60 * nPart);
        Dialogs.centerWindow((Shell)this.shell, (Shell)parent);
    }

    private void setData(Manifest manifest) {
        this.manifest = manifest;
        this.edMergeInputRoot.setText(manifest.getMergeInputRoot());
        this.edPkgType.setText(manifest.getPackageType());
        this.edPkgID.setText(manifest.getPackageID());
        this.edSource.setText(manifest.getSourceLanguage().toString());
        this.edTarget.setText(manifest.getTargetLanguage().toString());
        this.edDate.setText(manifest.getDate());
        this.chkUseApprovedOnly.setSelection(manifest.useApprovedOnly());
        this.chkUpdateApprovedFlag.setSelection(manifest.updateApprovedFlag());
    }

    public boolean showDialog(Manifest manifest) {
        this.tableMod.setManifest(manifest);
        this.setData(manifest);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }
}

