/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import com.gc.iotools.stream.base.ExecutionModel;
import com.gc.iotools.stream.base.ExecutorServiceFactory;
import com.gc.iotools.stream.is.InputStreamFromOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;

public class ReadAheadInputStream
extends InputStreamFromOutputStream<Void> {
    private final InputStream source;

    public ReadAheadInputStream(InputStream source) {
        this(source, -1);
    }

    public ReadAheadInputStream(InputStream source, int bufferSize) {
        this(source, bufferSize, ExecutionModel.THREAD_PER_INSTANCE);
    }

    public ReadAheadInputStream(InputStream source, int bufferSize, ExecutionModel executionModel) {
        this(source, bufferSize, ExecutorServiceFactory.getExecutor(executionModel));
    }

    public ReadAheadInputStream(InputStream source, int bufferSize, ExecutorService executorService) {
        super(false, executorService, bufferSize > 0 ? bufferSize : 262144);
        this.source = source;
    }

    @Override
    protected Void produce(OutputStream sink) throws Exception {
        IOUtils.copy((InputStream)this.source, (OutputStream)sink);
        this.source.close();
        return null;
    }
}

