/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class Base64Util {
    private static final String ENCSTR = "#BeNcStr";
    private static final Charset CSUTF8 = StandardCharsets.UTF_8;

    public static String encodeString(String str) {
        Base64.Encoder encoder = Base64.getEncoder();
        return new String(encoder.encode(str.getBytes(CSUTF8)), CSUTF8);
    }

    static char[] encode(byte[] data) {
        Base64.Encoder encoder = Base64.getEncoder();
        return new String(encoder.encode(data), CSUTF8).toCharArray();
    }

    static char[] encode(byte[] data, int iLen) {
        if (iLen > data.length) {
            iLen = data.length;
        }
        if (iLen == data.length) {
            return Base64Util.encode(data);
        }
        return Base64Util.encode(Arrays.copyOf(data, iLen));
    }

    public static String decodeString(String str) {
        str = str.replaceAll("[\r\n]", "");
        return new String(Base64Util.decode(str), CSUTF8);
    }

    static byte[] decode(String str) {
        str = str.replaceAll("[\r\n]", "");
        return Base64Util.decode(str.toCharArray());
    }

    static byte[] decode(char[] data) {
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(new String(data));
    }

    public static String encode(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("Input stream for Base64 encoding cannot be null.");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int bytesRead = 0;
        try {
            while ((bytesRead = is.read(buffer)) > 0) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("I/O exception while reading data for Base64 encoding.", e);
        }
        return new String(Base64Util.encode(os.toByteArray()));
    }

    public static String encodePassword(String password) {
        return ENCSTR + Base64Util.encodeString(password);
    }

    public static String decodePassword(String password) {
        if (password.startsWith(ENCSTR)) {
            return Base64Util.decodeString(password.substring(ENCSTR.length()));
        }
        return password;
    }
}

