/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharsetStore {
    public static final CharsetStore UTF_8 = new CharsetStore(StandardCharsets.UTF_8);
    public static final CharsetStore UTF_16 = new CharsetStore(StandardCharsets.UTF_16);
    public static final CharsetStore UTF_16BE = new CharsetStore(StandardCharsets.UTF_16BE);
    public static final CharsetStore UTF_16LE = new CharsetStore(StandardCharsets.UTF_16LE);
    public static final String UNKNOWN_CHARSET_NAME = "null";
    public static final CharsetStore UNKNOWN = new CharsetStore("null");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String charsetName;
    private Charset charset;

    public CharsetStore(Charset charset) {
        if (charset == null) {
            this.logger.warn("CharsetStore constructor called with null Charset");
            this.charset = null;
            this.charsetName = UNKNOWN_CHARSET_NAME;
        } else {
            this.charset = charset;
            this.charsetName = null;
        }
    }

    public CharsetStore(String charsetName) {
        if (charsetName == null) {
            this.logger.warn("CharsetStore constructor called with null charsetName");
            this.charset = null;
            this.charsetName = UNKNOWN_CHARSET_NAME;
        } else {
            this.charsetName = charsetName;
            this.charset = null;
        }
    }

    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = Charset.forName(this.charsetName);
        }
        return this.charset;
    }

    public String getCharsetName() {
        if (this.charsetName == null) {
            this.charsetName = this.charset.name();
        }
        return this.charsetName;
    }

    public String toString() {
        return this.getCharsetName();
    }
}

