/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.sf.okapi.common.IParameterDescriptor;
import net.sf.okapi.common.exceptions.OkapiException;

public class ParameterDescriptor
implements IParameterDescriptor {
    private final String name;
    private String shortDescription;
    private String displayName;
    private Type type;
    private final Object parent;
    private Method readMethod;
    private Method writeMethod;

    public ParameterDescriptor(String name, Object parent, String displayName, String shortDescription) {
        this.name = name;
        this.parent = parent;
        this.displayName = displayName;
        this.shortDescription = shortDescription;
        if (parent == null) {
            return;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(parent.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                this.readMethod = pd.getReadMethod();
                this.writeMethod = pd.getWriteMethod();
            }
        }
        catch (IntrospectionException e) {
            throw new OkapiException(String.format("Introspection error when creating descriptor for '%s'", name), e);
        }
        if (this.readMethod == null) {
            throw new NullPointerException(String.format("The readMethod for '%s' is null.\n(Getter maybe not declared or not following Java Bean naming convention?)", name));
        }
        this.type = this.readMethod.getGenericReturnType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }
}

