/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiMisAlignmentException;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeMatchStrategy;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class RenumberingUtil {
    public static void renumberCodesForSegmentation(TextContainer tc) {
        if (tc == null || tc.isEmpty()) {
            return;
        }
        boolean inUnmatched = false;
        int unmatchedMinId = 0;
        for (Segment seg : tc.getSegments()) {
            TextFragment tf = seg.getContent();
            if (RenumberingUtil.containsOnlyMatchingCodes(tf)) {
                inUnmatched = false;
                RenumberingUtil.reduceCodeIdsByOffset(tf, RenumberingUtil.calculateCodeOffset(tf));
                continue;
            }
            if (!inUnmatched) {
                inUnmatched = true;
                unmatchedMinId = RenumberingUtil.calculateCodeOffset(tf);
                RenumberingUtil.reduceCodeIdsByOffset(tf, unmatchedMinId);
                continue;
            }
            RenumberingUtil.reduceCodeIdsByOffset(tf, unmatchedMinId);
        }
    }

    public static void renumberTextUnitCodes(ITextUnit tu, LocaleId trgLocale) {
        if (tu == null || tu.isEmpty()) {
            return;
        }
        TextContainer source = tu.getSource();
        if (source != null && !source.isEmpty()) {
            RenumberingUtil.renumberCodesForSegmentation(source);
        }
        if (!tu.hasTarget(trgLocale)) {
            return;
        }
        IAlignedSegments bilingualSegs = tu.getAlignedSegments();
        if (bilingualSegs.getAlignmentStatus() != AlignmentStatus.ALIGNED) {
            throw new OkapiMisAlignmentException("Cannot safely renumber code ids. Source and target segments are not aligned.");
        }
        Iterator<Segment> srcSegIterator = bilingualSegs.iterator(trgLocale);
        while (srcSegIterator.hasNext()) {
            Segment srcSegment = srcSegIterator.next();
            Segment trgSegment = bilingualSegs.getCorrespondingTarget(srcSegment, trgLocale);
            trgSegment.getContent().alignCodeIds(srcSegment.getContent(), CodeMatchStrategy.LAX);
        }
    }

    public static int calculateCodeOffset(TextFragment tf) {
        if (tf.getCodes().isEmpty()) {
            return 0;
        }
        int minId = Integer.MAX_VALUE;
        for (Code code : tf.getCodes()) {
            if (minId <= code.getId()) continue;
            minId = code.getId();
        }
        return minId - 1;
    }

    private static void reduceCodeIdsByOffset(TextFragment tf, int offset) {
        for (Code code : tf.getCodes()) {
            code.setId(code.getId() - offset);
        }
    }

    public static boolean containsOnlyMatchingCodes(TextFragment tf) {
        List<Code> codes = tf.getCodes();
        int minId = Integer.MAX_VALUE;
        int maxId = Integer.MIN_VALUE;
        for (Code code : codes) {
            int id = code.getId();
            if (id < minId) {
                minId = id;
            }
            if (id <= maxId) continue;
            maxId = id;
        }
        int size = maxId - minId + 1;
        int[] values = new int[size];
        for (Code c : codes) {
            int index;
            int id = c.getId();
            int n = index = id - minId;
            values[n] = values[n] + RenumberingUtil.codeVal(c);
        }
        for (int i = 0; i < size; ++i) {
            if (values[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static int codeVal(Code c) {
        switch (c.getTagType()) {
            case OPENING: {
                return 1;
            }
            case CLOSING: {
                return -1;
            }
            case PLACEHOLDER: {
                return 0;
            }
        }
        return 0;
    }

    public static void renumberCodesForDesegmentation(TextContainer tc) {
        if (tc == null) {
            return;
        }
        int nextId = 1;
        boolean inUnmatched = false;
        int unmatchedDelta = 0;
        for (Segment seg : tc.getSegments()) {
            TextFragment tf = seg.getContent();
            int count = tf.getCodes().size();
            if (count == 0) continue;
            if (RenumberingUtil.containsOnlyMatchingCodes(tf)) {
                inUnmatched = false;
                nextId += RenumberingUtil.incrementCodeIdsByOffset(tf, nextId - 1);
                continue;
            }
            if (!inUnmatched) {
                inUnmatched = true;
                unmatchedDelta = nextId - 1;
                nextId += RenumberingUtil.incrementCodeIdsByOffset(tf, unmatchedDelta);
                continue;
            }
            nextId += RenumberingUtil.incrementCodeIdsByOffset(tf, unmatchedDelta);
        }
    }

    private static int incrementCodeIdsByOffset(TextFragment tf, int delta) {
        int count = 0;
        for (Code code : tf.getCodes()) {
            code.setId(code.getId() + delta);
            if (code.getTagType() == TextFragment.TagType.CLOSING) continue;
            ++count;
        }
        return count;
    }
}

