/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.List;
import net.sf.okapi.common.Sanitiser;

public final class StringSanitiser
implements Sanitiser<String> {
    private final List<Sanitiser.Filter<String>> filters;

    public StringSanitiser(List<Sanitiser.Filter<String>> filters) {
        this.filters = filters;
    }

    @Override
    public String sanitise(String value) {
        String sanitisedValue = value;
        for (Sanitiser.Filter<String> filter : this.filters) {
            sanitisedValue = filter.apply(sanitisedValue);
        }
        return sanitisedValue;
    }

    public static final class DoubleParsingFilter
    implements Sanitiser.Filter<String> {
        private final String errorMessageFormat;

        public DoubleParsingFilter(String errorMessageFormat) {
            this.errorMessageFormat = errorMessageFormat;
        }

        @Override
        public String apply(String value) {
            try {
                return Double.valueOf(value).toString();
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException(String.format(this.errorMessageFormat, value), exception);
            }
        }
    }

    public static final class IntegerParsingFilter
    implements Sanitiser.Filter<String> {
        private final String errorMessageFormat;

        public IntegerParsingFilter(String errorMessageFormat) {
            this.errorMessageFormat = errorMessageFormat;
        }

        @Override
        public String apply(String value) {
            try {
                return Integer.valueOf(value).toString();
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException(String.format(this.errorMessageFormat, value), exception);
            }
        }
    }

    public static final class TrimmingFilter
    implements Sanitiser.Filter<String> {
        @Override
        public String apply(String value) {
            return value.trim();
        }
    }
}

