/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class UserConfiguration
extends Properties {
    private static final long serialVersionUID = 1L;

    public UserConfiguration() {
        this.defaults = new Properties();
    }

    public void load(String appName) {
        try (FileInputStream input = new FileInputStream(new File(System.getProperty("user.home") + File.separator + "." + appName));){
            this.load(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save(String appName, String version) {
        try (FileOutputStream output = new FileOutputStream(new File(System.getProperty("user.home") + File.separator + "." + appName));){
            this.store(output, appName + " - " + version);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Object setProperty(String key, String value) {
        if (value == null) {
            return this.remove(key);
        }
        return super.setProperty(key, value);
    }

    public boolean getBoolean(String key) {
        return "true".equals(this.getProperty(key, "false"));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return "true".equals(this.getProperty(key, defaultValue ? "true" : "false"));
    }

    public Object setProperty(String key, boolean value) {
        return super.setProperty(key, value ? "true" : "false");
    }

    public int getInteger(String key) {
        return Integer.valueOf(this.getProperty(key, "0"));
    }

    public Object setProperty(String key, int value) {
        return super.setProperty(key, String.valueOf(value));
    }
}

