/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.security.InvalidParameterException;
import java.util.LinkedHashMap;
import java.util.Set;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.TextContainer;

public class GenericAnnotation
extends InlineAnnotation {
    private static final String FIELD_SEPARATOR = "\u009b";
    private static final String PART_SEPARATOR = "\u0099";
    private String type;
    private LinkedHashMap<String, Object> map;

    public static GenericAnnotation createFromString(String storage) {
        GenericAnnotation annotation = new GenericAnnotation();
        annotation.fromString(storage);
        return annotation;
    }

    public static void addAnnotation(ITextUnit tu, GenericAnnotation ann) {
        if (ann == null) {
            return;
        }
        GenericAnnotations anns = tu.getAnnotation(GenericAnnotations.class);
        if (anns == null) {
            anns = new GenericAnnotations();
            tu.setAnnotation(anns);
        }
        anns.add(ann);
    }

    public static void addAnnotation(TextContainer tc, GenericAnnotation ann) {
        if (ann == null) {
            return;
        }
        GenericAnnotations anns = tc.getAnnotation(GenericAnnotations.class);
        if (anns == null) {
            anns = new GenericAnnotations();
            tc.setAnnotation(anns);
        }
        anns.add(ann);
    }

    public static void addAnnotation(Code code, GenericAnnotation ann) {
        if (ann == null) {
            return;
        }
        GenericAnnotations anns = (GenericAnnotations)code.getAnnotation("generic");
        if (anns == null) {
            anns = new GenericAnnotations();
            code.setAnnotation("generic", anns);
        }
        anns.add(ann);
    }

    public GenericAnnotation() {
        this.map = null;
    }

    public GenericAnnotation(String type) {
        if (Util.isEmpty(type)) {
            throw new InvalidParameterException("The type of an annotation must not be null or empty.");
        }
        this.map = null;
        this.type = type;
    }

    public GenericAnnotation(String type, Object ... list) {
        this(type);
        this.setFields(list);
    }

    public void setFields(Object ... list) {
        for (int i = 0; i < list.length; i += 2) {
            if (!(list[i] instanceof String)) {
                throw new InvalidParameterException("Invalid field name in key+value pair.");
            }
            if (list[i + 1] instanceof String) {
                this.setString((String)list[i], (String)list[i + 1]);
                continue;
            }
            if (list[i + 1] instanceof Boolean) {
                this.setBoolean((String)list[i], (Boolean)list[i + 1]);
                continue;
            }
            if (list[i + 1] instanceof Integer) {
                this.setInteger((String)list[i], (Integer)list[i + 1]);
                continue;
            }
            if (list[i + 1] instanceof Double) {
                this.setDouble((String)list[i], (Double)list[i + 1]);
                continue;
            }
            if (list[i + 1] == null) continue;
            throw new InvalidParameterException("Invalid field value in key+value pair.");
        }
    }

    @Override
    public GenericAnnotation clone() {
        GenericAnnotation obj = new GenericAnnotation("z");
        obj.fromString(this.toString());
        return obj;
    }

    public String getType() {
        return this.type;
    }

    public String getString(String name) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof String)) {
            throw new InvalidParameterException(String.format("The field '%s' is not a string.", name));
        }
        return (String)obj;
    }

    public void setString(String name, String value) {
        this.setObject(name, value);
    }

    public Boolean getBoolean(String name) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Boolean)) {
            throw new InvalidParameterException(String.format("The field '%s' is not a boolean.", name));
        }
        return (Boolean)obj;
    }

    public Object getValue(String name) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        return obj;
    }

    public void setBoolean(String name, Boolean value) {
        this.setObject(name, value);
    }

    public Double getDouble(String name) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Double)) {
            throw new InvalidParameterException(String.format("The field '%s' is not a double.", name));
        }
        return (Double)obj;
    }

    public void setDouble(String name, Double value) {
        this.setObject(name, value);
    }

    public Integer getInteger(String name) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Integer)) {
            throw new InvalidParameterException(String.format("The field '%s' is not an integer.", name));
        }
        return (Integer)obj;
    }

    public void setInteger(String name, Integer value) {
        this.setObject(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.type);
        if (this.map == null) {
            return sb.toString();
        }
        for (String name : this.map.keySet()) {
            Object value = this.map.get(name);
            sb.append(FIELD_SEPARATOR);
            sb.append(name);
            sb.append(PART_SEPARATOR);
            if (value instanceof String) {
                sb.append('s');
            } else if (value instanceof Boolean) {
                sb.append('b');
            } else if (value instanceof Integer) {
                sb.append('i');
            } else if (value instanceof Double) {
                sb.append('f');
            }
            sb.append(PART_SEPARATOR);
            sb.append(value);
        }
        return sb.toString();
    }

    @Override
    public void fromString(String storage) {
        this.map = null;
        String[] fields = storage.split(FIELD_SEPARATOR, 0);
        this.type = fields[0];
        block12: for (int i = 1; i < fields.length; ++i) {
            String[] parts = fields[i].split(PART_SEPARATOR, -1);
            switch (parts[1]) {
                case "s": {
                    this.setString(parts[0], parts[2]);
                    continue block12;
                }
                case "b": {
                    this.setBoolean(parts[0], parts[2].equals("true"));
                    continue block12;
                }
                case "i": {
                    this.setInteger(parts[0], Integer.parseInt(parts[2]));
                    continue block12;
                }
                case "f": {
                    this.setDouble(parts[0], Double.parseDouble(parts[2]));
                    continue block12;
                }
                default: {
                    throw new OkapiException(String.format("Unknown field type in annotation: '%s'", parts[1]));
                }
            }
        }
    }

    public int getFieldCount() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    public Set<String> getNames() {
        return this.map.keySet();
    }

    public void remove(String name) {
        this.map.remove(name);
    }

    private void setObject(String name, Object value) {
        if (Util.isEmpty(name)) {
            throw new InvalidParameterException("The field name must not be null or empty.");
        }
        if (this.map == null) {
            this.map = new LinkedHashMap();
        }
        if (value == null) {
            this.map.remove(name);
        } else {
            this.map.put(name, value);
        }
    }
}

