/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.annotation.XLIFFPhase;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartSubDocument;

public class XLIFFPhaseAnnotation
implements IAnnotation {
    private List<XLIFFPhase> phases = new ArrayList<XLIFFPhase>();

    public void add(XLIFFPhase phase) {
        this.phases.add(phase);
    }

    public void add(XLIFFPhase phase, StartSubDocument startSubDoc) {
        this.phases.add(phase);
        this.updatePhaseAnnotation(startSubDoc);
    }

    public XLIFFPhase get(String phaseName) {
        for (XLIFFPhase phase : this.phases) {
            if (!phase.getPhaseName().equals(phaseName)) continue;
            return phase;
        }
        return null;
    }

    public XLIFFPhase getReferencedPhase() {
        if (this.phases.size() == 1) {
            return this.phases.get(0);
        }
        return null;
    }

    public void updatePhaseAnnotation(StartSubDocument startSubDoc) {
        Property phasePlaceholder = startSubDoc.getProperty("phase") == null ? new Property("phase", "") : startSubDoc.getProperty("phase");
        phasePlaceholder.setValue(this.toXML());
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<phase-group>");
        for (XLIFFPhase phase : this.phases) {
            sb.append(phase.toXML());
        }
        sb.append("</phase-group>");
        return sb.toString();
    }
}

