/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;

public interface IEncoder
extends Function<ITextUnit, ITextUnit> {
    public static <T> T runEncoders(List<Function<T, T>> functions, T t) {
        return functions.stream().reduce(Function.identity(), Function::andThen).apply(t);
    }

    public void reset();

    public void setOptions(IParameters var1, String var2, String var3);

    public String encode(String var1, EncoderContext var2);

    public String encode(int var1, EncoderContext var2);

    public String encode(char var1, EncoderContext var2);

    default public String toNative(String propertyName, String value) {
        return value;
    }

    default public String getLineBreak() {
        return "\n";
    }

    default public String getEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    default public CharsetEncoder getCharsetEncoder() {
        return StandardCharsets.UTF_8.newEncoder();
    }

    public IParameters getParameters();

    @Override
    default public ITextUnit apply(ITextUnit tu) {
        Consumer<Segment> encodeCodes = s -> {
            for (Code code : s.text.getCodes()) {
                code.setData(this.encode(code.getData(), EncoderContext.INLINE));
                String codeDisplayText = code.getDisplayText();
                if (codeDisplayText == null) continue;
                code.setDisplayText(this.encode(codeDisplayText, EncoderContext.TEXT));
            }
        };
        for (Segment s2 : tu.getSource().getSegments()) {
            String ct = s2.text.getCodedText();
            s2.text.setCodedText(this.encode(ct, EncoderContext.TEXT));
            encodeCodes.accept(s2);
        }
        for (LocaleId l : tu.getTargetLocales()) {
            for (Segment s3 : tu.getTarget(l).getSegments()) {
                String ct = s3.text.getCodedText();
                s3.text.setCodedText(this.encode(ct, EncoderContext.TEXT));
                encodeCodes.accept(s3);
            }
        }
        return tu;
    }
}

