/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;

public class IcuMessageEncoder
implements IEncoder {
    private CharsetEncoder chsEnc = StandardCharsets.UTF_8.newEncoder();
    private String lineBreak = "\n";
    private String encoding;
    private IParameters params;

    @Override
    public void reset() {
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.chsEnc = Charset.forName(encoding).newEncoder();
        this.lineBreak = lineBreak;
        this.encoding = encoding;
        this.params = params;
        if (params != null) {
            // empty if block
        }
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (text == null || text.isEmpty()) {
            return text;
        }
        return this.encode(text);
    }

    private String encode(String input) {
        StringBuilder sb = new StringBuilder();
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '{') {
                if (stack.isEmpty()) {
                    sb.append("'");
                }
                stack.push(sb.length());
                sb.append(c);
                continue;
            }
            if (c == '}') {
                if (stack.isEmpty()) continue;
                sb.append(c);
                int start = (Integer)stack.pop();
                if (!stack.isEmpty()) continue;
                sb.append("'");
                continue;
            }
            if (c == '\'') {
                if (stack.isEmpty()) {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public String encode(char value, EncoderContext context) {
        return this._encode(value, context);
    }

    protected String _encode(char value, EncoderContext context) {
        if (value > '\u007f') {
            if (Character.isHighSurrogate(value)) {
                return "";
            }
            return String.valueOf(value);
        }
        switch (value) {
            case '\'': {
                return "''";
            }
            case '{': {
                return "'{'";
            }
            case '}': {
                return "'}'";
            }
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (Character.isSupplementaryCodePoint(value)) {
            return new String(Character.toChars(value));
        }
        return this.encode((char)value, context);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }
}

