/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.DefaultParameters;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterParametersException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.ThreadSafeFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilter
implements IFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    List<FilterConfiguration> configList = new ArrayList<FilterConfiguration>();
    private IdGenerator documentId;
    private boolean canceled = false;
    private String documentName;
    private String newlineType;
    private String encoding = StandardCharsets.UTF_8.name();
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private String mimeType;
    private boolean generateSkeleton;
    private boolean multilingual;
    private String name;
    private String displayName;
    private EncoderManager encoderManager;
    private IFilterConfigurationMapper fcMapper;
    private String parentId;
    private IParameters params;
    private String parametersClassName;

    public AbstractFilter() {
        this.setNewlineType("\n");
        this.setMultilingual(false);
        this.fcMapper = new ThreadSafeFilterConfigurationMapper();
        this.documentId = new IdGenerator(null, "sd");
        this.params = new DefaultParameters();
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = params;
        if (params == null) {
            return;
        }
        this.parametersClassName = params.getClass().getName();
    }

    public <A> A getParameters(Class<A> expectedClass) {
        if (this.params == null) {
            throw new OkapiBadFilterParametersException("Filter parameters object is null. Use DefaultParameters instead");
        }
        if (!expectedClass.isInstance(this.params)) {
            String st = this.params.getClass().getName();
            throw new OkapiBadFilterParametersException(String.format("Parameters of class <%s> expected, but are <%s>", expectedClass.getName(), st));
        }
        return expectedClass.cast(this.params);
    }

    public String getParametersClassName() {
        return this.parametersClassName;
    }

    public void setOptions(LocaleId sourceLocale, LocaleId targetLocale, String defaultEncoding, boolean generateSkeleton) {
        this.setEncoding(defaultEncoding);
        this.setTrgLoc(targetLocale);
        this.setSrcLoc(sourceLocale);
        this.setGenerateSkeleton(generateSkeleton);
    }

    protected Event createStartFilterEvent() {
        StartDocument startDocument = new StartDocument(this.documentId.createId("sd"));
        startDocument.setEncoding(this.getEncoding(), this.isUtf8Encoding() && this.isUtf8Bom());
        startDocument.setLocale(this.getSrcLoc());
        startDocument.setMimeType(this.getMimeType());
        startDocument.setLineBreak(this.getNewlineType());
        startDocument.setFilterId(this.getName());
        startDocument.setFilterParameters(this.getParameters());
        startDocument.setFilterWriter(this.createFilterWriter());
        startDocument.setName(this.getDocumentName());
        startDocument.setMultilingual(this.isMultilingual());
        this.LOGGER.debug("Start Document for {}", (Object)startDocument.getId());
        return new Event(EventType.START_DOCUMENT, startDocument);
    }

    protected Event createEndFilterEvent() {
        Ending endDocument = new Ending(this.documentId.getLastId());
        this.LOGGER.debug("End Document for {}", (Object)endDocument.getId());
        return new Event(EventType.END_DOCUMENT, endDocument);
    }

    public FilterConfiguration getConfiguration(String configId) {
        if (Util.isEmpty(this.configList)) {
            return null;
        }
        for (FilterConfiguration config : this.configList) {
            if (config == null || !config.configId.equalsIgnoreCase(configId)) continue;
            return config;
        }
        return null;
    }

    public boolean removeConfiguration(String configId) {
        return this.configList.remove(this.getConfiguration(configId));
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> configs = new ArrayList<FilterConfiguration>();
        for (FilterConfiguration fc : this.configList) {
            configs.add(new FilterConfiguration(fc.configId, this.getMimeType(), this.getClass().getName(), fc.name, fc.description, fc.parametersLocation, fc.extensions));
        }
        return configs;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setAllKnownMappings();
            this.encoderManager.setDefaultOptions(this.getParameters(), "UTF-8", this.getNewlineType());
        }
        return this.encoderManager;
    }

    protected boolean addConfiguration(boolean clearAllExisting, String configId, String name, String description, String parametersLocation) {
        if (this.configList == null) {
            return false;
        }
        if (clearAllExisting) {
            this.configList.clear();
        }
        return this.configList.add(new FilterConfiguration(configId, this.getMimeType(), this.getClass().getName(), name, description, parametersLocation));
    }

    protected boolean addConfiguration(boolean clearAllExisting, String configId, String name, String description, String parametersLocation, String extensions) {
        if (this.configList == null) {
            return false;
        }
        if (clearAllExisting) {
            this.configList.clear();
        }
        return this.configList.add(new FilterConfiguration(configId, this.getMimeType(), this.getClass().getName(), name, description, parametersLocation, extensions));
    }

    protected boolean addConfigurations(List<FilterConfiguration> configs) {
        if (this.configList == null) {
            return false;
        }
        return this.configList.addAll(configs);
    }

    protected FilterConfiguration findConfiguration(String configId) {
        if (Util.isEmpty(this.configList)) {
            return null;
        }
        for (FilterConfiguration config : this.configList) {
            if (config == null || !config.configId.equalsIgnoreCase(configId)) continue;
            return config;
        }
        return null;
    }

    public void addConfiguration(FilterConfiguration configuration) {
        this.configList.add(configuration);
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.setNewlineType("\n");
        this.setMultilingual(false);
        this.documentId = new IdGenerator(null, "sd");
        this.parentId = null;
        this.canceled = false;
        this.multilingual = false;
        this.generateSkeleton = generateSkeleton;
    }

    protected IFilterConfigurationMapper getFilterConfigurationMapper() {
        return this.fcMapper;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    protected void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getNewlineType() {
        return this.newlineType;
    }

    protected void setNewlineType(String newlineType) {
        this.newlineType = newlineType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public LocaleId getSrcLoc() {
        return this.srcLoc;
    }

    public void setSrcLoc(LocaleId srcLoc) {
        this.srcLoc = srcLoc;
    }

    public LocaleId getTrgLoc() {
        return this.trgLoc;
    }

    public void setTrgLoc(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    public boolean isGenerateSkeleton() {
        return this.generateSkeleton;
    }

    protected void setGenerateSkeleton(boolean generateSkeleton) {
        this.generateSkeleton = generateSkeleton;
    }

    @Override
    public boolean isMultilingual() {
        return this.multilingual;
    }

    protected void setMultilingual(boolean multilingual) {
        this.multilingual = multilingual;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public IdGenerator getDocumentId() {
        return this.documentId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    protected boolean isUtf8Encoding() {
        return true;
    }

    protected boolean isUtf8Bom() {
        return false;
    }
}

