/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.ISubFilter;
import net.sf.okapi.common.filters.SubFilterEventConverter;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartSubfilter;

public abstract class AbstractSubFilter
extends AbstractFilter
implements ISubFilter {
    private String parentType;
    private StartSubfilter startSubFilter;
    private String parentName;
    private String parentId;
    private int sectionIndex;
    private IEncoder parentEncoder;
    private EndSubfilter endSubFilter;
    private SubFilterEventConverter converter;
    private ITextUnit parentTexUnit;

    protected Event convertEvent(Event event) {
        if (this.getConverter() != null) {
            return this.getConverter().convertEvent(event);
        }
        return event;
    }

    @Override
    public List<Event> getEvents(RawDocument input) {
        LinkedList<Event> events = new LinkedList<Event>();
        try {
            this.open(input);
            while (this.hasNext()) {
                events.add(this.next());
            }
        }
        finally {
            this.close();
        }
        return Collections.unmodifiableList(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Event> getEvents(ITextUnit tu, LocaleId sourceLocale, LocaleId targetLocale) {
        LinkedList<Event> events = new LinkedList<Event>();
        try (RawDocument doc = new RawDocument(tu.getSource().getUnSegmentedContentCopy(), sourceLocale, targetLocale);){
            this.open(doc);
            this.setParentUnit(tu);
            while (this.hasNext()) {
                Event e = this.next();
                if (e.isTextUnit()) {
                    ITextUnit stu = e.getTextUnit();
                    IWithProperties.copy(tu, stu);
                    IWithAnnotations.copy(tu, stu);
                }
                events.add(e);
            }
        }
        finally {
            this.close();
        }
        return Collections.unmodifiableList(events);
    }

    private void setParentUnit(ITextUnit tu) {
        if (tu != null) {
            this.setParentId(tu.getId());
            this.setParentName(tu.getName());
            this.setParentType(tu.getType());
            this.parentTexUnit = tu;
        }
    }

    @Override
    public StartSubfilter getStartSubfilter() {
        return this.startSubFilter;
    }

    @Override
    public void setStartSubfilter(StartSubfilter startSubfilter) {
        this.startSubFilter = startSubfilter;
        this.startSubFilter.setParentTextUnit(this.parentTexUnit);
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @Override
    public int getSectionIndex() {
        return this.sectionIndex;
    }

    @Override
    public void setSectionIndex(int sectionIndex) {
        this.sectionIndex = sectionIndex;
    }

    @Override
    public String getParentType() {
        return this.parentType;
    }

    @Override
    public void setParentType(String parentType) {
        this.parentType = parentType;
    }

    @Override
    public void setParentEncoder(IEncoder parentEncoder) {
        this.parentEncoder = parentEncoder;
    }

    @Override
    public void setEndSubfilter(EndSubfilter endSubfilter) {
        this.endSubFilter = endSubfilter;
    }

    @Override
    public void setConverter(SubFilterEventConverter converter) {
        this.converter = converter;
    }

    @Override
    public SubFilterEventConverter getConverter() {
        return this.converter;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
}

