/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.ISubFilter;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.IMultilingual;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBuilder
implements Iterator<Event> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String mimeType;
    private IdGenerator groupId;
    private IdGenerator textUnitId;
    private IdGenerator subDocumentId;
    private IdGenerator documentPartId;
    private Stack<Event> tempFilterEventStack;
    private Stack<Code> codeStack;
    private List<Event> filterEvents;
    private boolean done = false;
    private boolean preserveWhitespace;
    private GenericSkeleton currentSkeleton;
    private DocumentPart currentDocumentPart;
    private String rootId;
    private boolean subFilter;

    public EventBuilder() {
        this.reset(null, null);
    }

    public EventBuilder(String rootId, IFilter filter) {
        this.reset(rootId, filter);
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public Event next() {
        if (this.hasNext() && !this.filterEvents.isEmpty()) {
            Event event = this.filterEvents.remove(0);
            if (event.getEventType() == EventType.END_DOCUMENT) {
                this.done = true;
            }
            if (this.subFilter && event.isEndSubfilter()) {
                this.done = true;
            }
            return event;
        }
        return null;
    }

    public void addFilterEvent(Event event) {
        this.filterEvents.add(event);
    }

    public void addFilterEvents(List<Event> events) {
        if (Util.isEmpty(events)) {
            return;
        }
        this.filterEvents.addAll(events);
    }

    public void cancel() {
        this.filterEvents.clear();
        Event event = new Event(EventType.CANCELED);
        this.filterEvents.add(event);
    }

    public Event peekTempEvent() {
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        return this.tempFilterEventStack.peek();
    }

    public Event popTempEvent() {
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        return this.tempFilterEventStack.pop();
    }

    public Event popFilterEvent() {
        if (this.filterEvents.isEmpty()) {
            return null;
        }
        return this.filterEvents.remove(this.filterEvents.size() - 1);
    }

    public void flushRemainingTempEvents() {
        while (!this.tempFilterEventStack.isEmpty()) {
            Event fe = this.tempFilterEventStack.peek();
            switch (fe.getEventType()) {
                case START_GROUP: {
                    StartGroup sg = fe.getStartGroup();
                    this.endGroup((GenericSkeleton)sg.getSkeleton());
                    break;
                }
                case START_SUBFILTER: {
                    StartSubfilter sf = fe.getStartSubfilter();
                    this.endGroup((GenericSkeleton)sf.getSkeleton());
                    break;
                }
                case TEXT_UNIT: {
                    this.endTextUnit();
                }
            }
        }
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        }
    }

    public boolean isCurrentTextUnit() {
        Event e = this.peekTempEvent();
        return e != null && e.getEventType() == EventType.TEXT_UNIT;
    }

    public boolean isCurrentComplexTextUnit() {
        Event e = this.peekTempEvent();
        return e != null && e.getEventType() == EventType.TEXT_UNIT && e.getResource().getSkeleton() != null;
    }

    public boolean isCurrentGroup() {
        Event e = this.peekTempEvent();
        return e != null && e.getEventType() == EventType.START_GROUP;
    }

    public boolean isCurrentSubfilter() {
        Event e = this.peekTempEvent();
        return e != null && e.getEventType() == EventType.START_SUBFILTER;
    }

    public boolean isInsideTextRun() {
        return this.isCurrentTextUnit();
    }

    public boolean canStartNewTextUnit() {
        return !this.isCurrentTextUnit();
    }

    public boolean hasQueuedEvents() {
        return !this.filterEvents.isEmpty();
    }

    public String findMostRecentParentId() {
        StartGroup parentGroup;
        ITextUnit tu;
        if (this.isCurrentComplexTextUnit() && (tu = this.peekMostRecentTextUnit()) != null) {
            return tu.getId();
        }
        if (this.isCurrentGroup() && (parentGroup = this.peekMostRecentGroup()) != null) {
            return parentGroup.getId();
        }
        StartSubDocument parentSubDocument = this.peekMostRecentSubDocument();
        if (parentSubDocument != null) {
            return parentSubDocument.getId();
        }
        return null;
    }

    public String findMostRecentParentName() {
        StartGroup parentGroup;
        ITextUnit tu;
        if (this.isCurrentComplexTextUnit() && (tu = this.peekMostRecentTextUnit()) != null) {
            return tu.getName();
        }
        if (this.isCurrentGroup() && (parentGroup = this.peekMostRecentGroup()) != null) {
            return parentGroup.getName();
        }
        StartSubDocument parentSubDocument = this.peekMostRecentSubDocument();
        if (parentSubDocument != null) {
            return parentSubDocument.getName();
        }
        return null;
    }

    public String findMostRecentTextUnitName() {
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        for (Event fe : this.tempFilterEventStack) {
            if (fe.getEventType() != EventType.TEXT_UNIT || fe.getTextUnit().getName() == null) continue;
            return fe.getTextUnit().getName();
        }
        return null;
    }

    public StartGroup peekMostRecentGroup() {
        int lastIndex;
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        for (int i = lastIndex = this.tempFilterEventStack.size() - 1; i >= 0; --i) {
            Event fe = (Event)this.tempFilterEventStack.get(i);
            if (fe.isStartGroup()) {
                return fe.getStartGroup();
            }
            if (!fe.isStartSubfilter()) continue;
            return fe.getStartSubfilter();
        }
        return null;
    }

    public StartSubDocument peekMostRecentSubDocument() {
        int lastIndex;
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        for (int i = lastIndex = this.tempFilterEventStack.size() - 1; i >= 0; --i) {
            Event fe = (Event)this.tempFilterEventStack.get(i);
            if (!fe.isStartSubDocument()) continue;
            return fe.getStartSubDocument();
        }
        return null;
    }

    public ITextUnit peekMostRecentTextUnit() {
        int lastIndex;
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        for (int i = lastIndex = this.tempFilterEventStack.size() - 1; i >= 0; --i) {
            Event fe = (Event)this.tempFilterEventStack.get(i);
            if (!fe.isTextUnit()) continue;
            return fe.getTextUnit();
        }
        return null;
    }

    public Code peekMostRecentCode() {
        if (this.codeStack.isEmpty()) {
            return null;
        }
        Code c = null;
        try {
            c = this.codeStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return c;
    }

    public boolean hasUnfinishedSkeleton() {
        return this.currentSkeleton != null;
    }

    public boolean hasParentTextUnit() {
        if (this.tempFilterEventStack.isEmpty()) {
            return false;
        }
        boolean first = true;
        for (Event fe : this.tempFilterEventStack) {
            if (fe.getEventType() == EventType.TEXT_UNIT && !first) {
                return true;
            }
            first = false;
        }
        return false;
    }

    public void reset(String rootId, IFilter filter) {
        this.rootId = rootId;
        this.subFilter = filter instanceof ISubFilter;
        this.groupId = new IdGenerator(rootId, "sg");
        this.textUnitId = new IdGenerator(rootId, "tu");
        this.documentPartId = new IdGenerator(rootId, "dp");
        this.subDocumentId = new IdGenerator(rootId, "ssd");
        this.done = false;
        this.preserveWhitespace = true;
        this.filterEvents = new LinkedList<Event>();
        this.tempFilterEventStack = new Stack();
        this.codeStack = new Stack();
        this.currentSkeleton = null;
        this.currentDocumentPart = null;
    }

    public StartSubDocument startSubDocument() {
        StartSubDocument startSubDocument = null;
        if (!this.subFilter) {
            if (this.hasUnfinishedSkeleton()) {
                this.endDocumentPart();
            }
            startSubDocument = new StartSubDocument(this.subDocumentId.createId());
            Event event = new Event(EventType.START_SUBDOCUMENT, startSubDocument);
            this.filterEvents.add(event);
            this.LOGGER.debug("Start Sub-Document for {}", (Object)startSubDocument.getId());
        }
        return startSubDocument;
    }

    public void endSubDocument() {
        if (!this.subFilter) {
            Ending endDocument = new Ending(this.subDocumentId.createId("esd"));
            Event event = new Event(EventType.END_SUBDOCUMENT, endDocument);
            this.filterEvents.add(event);
            this.LOGGER.debug("End Sub-Document for {}", (Object)endDocument.getId());
        }
    }

    private ITextUnit embeddedTextUnit(PropertyTextUnitPlaceholder propOrText, String tag) {
        TextUnit tu = new TextUnit(this.textUnitId.createId(), propOrText.getValue());
        tu.setPreserveWhitespaces(this.preserveWhitespace);
        tu.setMimeType(propOrText.getMimeType());
        tu.setIsReferent(true);
        tu.setType(propOrText.getElementType() == null ? propOrText.getName() : propOrText.getElementType());
        GenericSkeleton skel = new GenericSkeleton();
        skel.add(tag.substring(propOrText.getMainStartPos(), propOrText.getValueStartPos()));
        skel.addContentPlaceholder(tu);
        skel.add(tag.substring(propOrText.getValueEndPos(), propOrText.getMainEndPos()));
        tu.setSkeleton(skel);
        this.postProcessTextUnit(tu);
        return tu;
    }

    private void embeddedWritableProp(IMultilingual resource, PropertyTextUnitPlaceholder propOrText, String tag, LocaleId locale) {
        this.setPropertyBasedOnLocale(resource, locale, new Property(propOrText.getName(), propOrText.getValue(), false));
        this.currentSkeleton.add(tag.substring(propOrText.getMainStartPos(), propOrText.getValueStartPos()));
        this.currentSkeleton.addValuePlaceholder(resource, propOrText.getName(), locale);
        this.currentSkeleton.add(tag.substring(propOrText.getValueEndPos(), propOrText.getMainEndPos()));
    }

    private void embeddedReadonlyProp(IMultilingual resource, PropertyTextUnitPlaceholder propOrText, String tag, LocaleId locId) {
        this.setPropertyBasedOnLocale(resource, locId, new Property(propOrText.getName(), propOrText.getValue(), true));
        this.currentSkeleton.add(tag.substring(propOrText.getMainStartPos(), propOrText.getMainEndPos()));
    }

    private INameable setPropertyBasedOnLocale(IMultilingual resource, LocaleId locale, Property property) {
        if (locale == null) {
            resource.setSourceProperty(property);
        } else if (locale.equals(LocaleId.EMPTY)) {
            resource.setProperty(property);
        } else {
            resource.setTargetProperty(locale, property);
        }
        return resource;
    }

    private boolean processAllEmbedded(String tag, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders, boolean inlineCode) {
        return this.processAllEmbedded(tag, locale, propertyTextUnitPlaceholders, inlineCode, null);
    }

    private boolean isTextPlaceHoldersOnly(List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        boolean text = false;
        boolean nontext = false;
        for (PropertyTextUnitPlaceholder propOrText : propertyTextUnitPlaceholders) {
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.TRANSLATABLE) {
                text = true;
                continue;
            }
            nontext = true;
        }
        return text && !nontext;
    }

    private boolean processAllEmbedded(String tag, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders, boolean inlineCode, ITextUnit parentTu) {
        int propOrTextId = -1;
        boolean textPlaceholdersOnly = this.isTextPlaceHoldersOnly(propertyTextUnitPlaceholders);
        IReferenceable resource = null;
        Code c = this.peekMostRecentCode();
        if (c != null) {
            c.setData("");
        }
        resource = inlineCode ? (textPlaceholdersOnly ? parentTu : new DocumentPart(this.documentPartId.createId(), inlineCode)) : (parentTu != null ? parentTu : this.currentDocumentPart);
        Collections.sort(propertyTextUnitPlaceholders);
        PropertyTextUnitPlaceholder pt = propertyTextUnitPlaceholders.get(0);
        this.currentSkeleton.add(tag.substring(0, pt.getMainStartPos()));
        for (PropertyTextUnitPlaceholder propOrText : propertyTextUnitPlaceholders) {
            if (++propOrTextId >= 1 && propOrTextId < propertyTextUnitPlaceholders.size()) {
                PropertyTextUnitPlaceholder pt1 = propertyTextUnitPlaceholders.get(propOrTextId - 1);
                PropertyTextUnitPlaceholder pt2 = propertyTextUnitPlaceholders.get(propOrTextId);
                this.currentSkeleton.add(tag.substring(pt1.getMainEndPos(), pt2.getMainStartPos()));
            }
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.TRANSLATABLE) {
                ITextUnit tu = this.embeddedTextUnit(propOrText, tag);
                this.currentSkeleton.addReference(tu);
                this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
                continue;
            }
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.WRITABLE_PROPERTY) {
                this.embeddedWritableProp((IMultilingual)((Object)resource), propOrText, tag, locale);
                continue;
            }
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.READ_ONLY_PROPERTY) {
                this.embeddedReadonlyProp((IMultilingual)((Object)resource), propOrText, tag, locale);
                continue;
            }
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.NAME) {
                resource.setName(propOrText.getValue() + "-" + propOrText.getName());
                this.embeddedReadonlyProp((IMultilingual)((Object)resource), propOrText, tag, locale);
                continue;
            }
            throw new OkapiIllegalFilterOperationException("Unknown Property or TextUnit type");
        }
        pt = propertyTextUnitPlaceholders.get(propertyTextUnitPlaceholders.size() - 1);
        this.currentSkeleton.add(tag.substring(pt.getMainEndPos()));
        if (inlineCode) {
            Code code = this.peekMostRecentCode();
            if (!textPlaceholdersOnly) {
                if (code != null) {
                    code.appendReference(resource.getId());
                }
                resource.setSkeleton(this.currentSkeleton);
                this.filterEvents.add(new Event(EventType.DOCUMENT_PART, (IResource)((Object)resource)));
            } else if (code != null) {
                code.append(this.currentSkeleton.toString());
                code.setReferenceFlag(true);
            }
        }
        return textPlaceholdersOnly;
    }

    public void addTextUnit(String text) {
        if (Util.isEmpty(text)) {
            return;
        }
        this.startTextUnit(text, null, null, null);
        this.endTextUnit();
    }

    public void startTextUnit(String text) {
        this.startTextUnit(text, null, null, null);
    }

    public void startTextUnit() {
        this.startTextUnit(null, null, null, null);
    }

    public void startTextUnit(GenericSkeleton startMarker) {
        this.startTextUnit(null, startMarker, null, null);
    }

    public void startTextUnit(GenericSkeleton startMarker, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.startTextUnit(null, startMarker, null, propertyTextUnitPlaceholders);
    }

    public void startTextUnit(String text, GenericSkeleton startMarker, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.startTextUnit(text, startMarker, null, propertyTextUnitPlaceholders);
    }

    public void startTextUnit(String text, GenericSkeleton startMarker, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        }
        TextUnit tu = new TextUnit(this.textUnitId.createId(), text);
        tu.setMimeType(this.mimeType);
        tu.setPreserveWhitespaces(this.preserveWhitespace);
        Event e = this.peekTempEvent();
        if (e != null && e.getEventType() == EventType.TEXT_UNIT) {
            ITextUnit parentTu = e.getTextUnit();
            if (parentTu.getSource().isEmpty()) {
                this.convertTempTextUnitToDocumentPart();
            } else {
                tu.setIsReferent(true);
                GenericSkeleton skel = (GenericSkeleton)parentTu.getSkeleton();
                if (skel == null) {
                    skel = new GenericSkeleton();
                }
                skel.addReference(tu);
                parentTu.setSkeleton(skel);
            }
        }
        if (startMarker != null && propertyTextUnitPlaceholders != null) {
            this.currentSkeleton = new GenericSkeleton();
            this.processAllEmbedded(startMarker.toString(), locale, propertyTextUnitPlaceholders, false, tu);
            tu.setSkeleton(this.currentSkeleton);
            this.currentSkeleton.addContentPlaceholder(tu);
            this.tempFilterEventStack.push(new Event(EventType.TEXT_UNIT, tu, this.currentSkeleton));
            this.currentSkeleton = null;
        } else if (startMarker != null) {
            GenericSkeleton skel = new GenericSkeleton(startMarker);
            skel.addContentPlaceholder(tu);
            this.tempFilterEventStack.push(new Event(EventType.TEXT_UNIT, tu, skel));
        } else {
            this.tempFilterEventStack.push(new Event(EventType.TEXT_UNIT, tu));
        }
    }

    public void convertTempTextUnitToDocumentPart() {
        if (this.peekTempEvent().getEventType() != EventType.TEXT_UNIT) {
            return;
        }
        Event e = this.popTempEvent();
        ITextUnit textUnit = e.getTextUnit();
        GenericSkeleton oldTuSkeleton = (GenericSkeleton)textUnit.getSkeleton();
        if (oldTuSkeleton != null) {
            GenericSkeleton newDpSkeleton = new GenericSkeleton();
            List<GenericSkeletonPart> parts = oldTuSkeleton.getParts();
            for (int i = 0; i < parts.size() - 1; ++i) {
                newDpSkeleton.add(parts.get(i));
            }
            this.addToDocumentPart(newDpSkeleton);
            this.endDocumentPart();
        }
    }

    public ITextUnit endTextUnit() {
        return this.endTextUnit(null, null, null);
    }

    public ITextUnit endTextUnit(GenericSkeleton endMarker) {
        return this.endTextUnit(endMarker, null, null);
    }

    public ITextUnit endTextUnit(GenericSkeleton endMarker, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (!this.isCurrentTextUnit()) {
            if (endMarker != null) {
                this.addDocumentPart(endMarker.toString());
            }
            return null;
        }
        Event tempTextUnit = this.popTempEvent();
        if (endMarker != null) {
            GenericSkeleton skel = (GenericSkeleton)tempTextUnit.getResource().getSkeleton();
            if (skel == null) {
                skel = new GenericSkeleton();
                skel.addContentPlaceholder(tempTextUnit.getTextUnit());
                skel.add(endMarker);
                tempTextUnit.getResource().setSkeleton(skel);
            } else {
                skel.add(endMarker);
            }
        }
        tempTextUnit.setResource(this.postProcessTextUnit(tempTextUnit.getTextUnit()));
        this.filterEvents.add(tempTextUnit);
        ITextUnit tu = tempTextUnit.getTextUnit();
        tu.getSource().getFirstContent().renumberCodes();
        return (ITextUnit)tempTextUnit.getResource();
    }

    public void addToTextUnit(String text) {
        if (Util.isEmpty(text)) {
            return;
        }
        if (!this.isCurrentTextUnit()) {
            throw new OkapiIllegalFilterOperationException("Trying to add text to a TextUnit that does not exist.");
        }
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu == null) {
            return;
        }
        tu.getSource().getFirstContent().append(text);
    }

    public void addToTextUnit(Property property) {
        if (property == null) {
            return;
        }
        if (!this.isCurrentTextUnit()) {
            throw new OkapiIllegalFilterOperationException("Trying to add Property to a TextUnit that does not exist.");
        }
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu == null) {
            return;
        }
        tu.setProperty(property);
    }

    public void addToTextUnit(Code code) {
        this.addToTextUnit(code, true);
    }

    public void addToTextUnit(Code code, boolean endCodeNow) {
        if (!this.isCurrentTextUnit()) {
            throw new OkapiIllegalFilterOperationException("Trying to add a Code to a TextUnit that does not exist.");
        }
        this.startCode(code);
        if (endCodeNow) {
            this.endCode();
        }
    }

    public void addToTextUnit(Code code, boolean endCodeNow, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.addToTextUnit(code, endCodeNow, null, propertyTextUnitPlaceholders);
    }

    public void addToTextUnit(Code code, boolean endCodeNow, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (!this.isCurrentTextUnit()) {
            throw new OkapiIllegalFilterOperationException("Trying to add Codes to a TextUnit that does not exist.");
        }
        this.currentSkeleton = new GenericSkeleton();
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            this.startCode(code);
            this.processAllEmbedded(code.toString(), locale, propertyTextUnitPlaceholders, true, tu);
            if (endCodeNow) {
                this.endCode();
            }
        }
        this.currentSkeleton = null;
    }

    public void appendToFirstSkeletonPart(String text) {
        Event tempTextUnit = this.peekTempEvent();
        GenericSkeleton skel = (GenericSkeleton)tempTextUnit.getResource().getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
            tempTextUnit.getResource().setSkeleton(skel);
        }
        skel.appendToFirstPart(text);
    }

    public void appendToSkeleton(GenericSkeleton part) {
        Event tempTextUnit = this.peekTempEvent();
        GenericSkeleton skel = (GenericSkeleton)tempTextUnit.getResource().getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
            tempTextUnit.getResource().setSkeleton(skel);
        }
        skel.add(part);
    }

    public void appendToSkeleton(GenericSkeletonPart part) {
        Event tempTextUnit = this.peekTempEvent();
        GenericSkeleton skel = (GenericSkeleton)tempTextUnit.getResource().getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
            tempTextUnit.getResource().setSkeleton(skel);
        }
        skel.add(part);
    }

    public void appendToSkeleton(String text) {
        Event tempTextUnit = this.peekTempEvent();
        GenericSkeleton skel = (GenericSkeleton)tempTextUnit.getResource().getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
            tempTextUnit.getResource().setSkeleton(skel);
        }
        skel.add(text);
    }

    public StartGroup startGroup(GenericSkeleton startMarker, String commonTagType) {
        return this.startGroup(startMarker, commonTagType, null, null);
    }

    public StartGroup startGroup(GenericSkeleton startMarker, String commonTagType, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (startMarker == null) {
            throw new OkapiIllegalFilterOperationException("startMarker for Group is null");
        }
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        }
        if (startMarker != null && propertyTextUnitPlaceholders != null) {
            this.processAllEmbedded(startMarker.toString(), locale, propertyTextUnitPlaceholders, false);
        }
        String gid = this.groupId.createId();
        StartGroup g = new StartGroup(this.findMostRecentParentId(), gid);
        GenericSkeleton skel = new GenericSkeleton(startMarker);
        Event fe = new Event(EventType.START_GROUP, g, skel);
        if (this.isCurrentTextUnit()) {
            g.setIsReferent(true);
            Code c = new Code(TextFragment.TagType.PLACEHOLDER, commonTagType, TextFragment.makeRefMarker(gid));
            c.setReferenceFlag(true);
            this.startCode(c);
            this.endCode();
        }
        this.filterEvents.add(fe);
        this.tempFilterEventStack.push(fe);
        return g;
    }

    public void addToGroup(Property property) {
        if (property == null) {
            return;
        }
        if (!this.isCurrentGroup()) {
            throw new OkapiIllegalFilterOperationException("Trying to add a Property to a Group that does not exist.");
        }
        StartGroup sg = this.peekMostRecentGroup();
        if (sg == null) {
            throw new OkapiIllegalFilterOperationException("Trying to add a Property to a Group that does not exist.");
        }
        sg.setProperty(property);
    }

    public Ending endGroup(GenericSkeleton endMarker) {
        return this.endGroup(endMarker, null, null);
    }

    public Ending endGroup(GenericSkeleton endMarker, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (!this.isCurrentGroup()) {
            if (endMarker != null) {
                this.addDocumentPart(endMarker.toString());
            }
            this.LOGGER.warn("Trying to end a Group that does not exist.  Possible unbalanced Group tags.");
            return null;
        }
        GenericSkeleton skel = new GenericSkeleton();
        if (this.currentSkeleton != null) {
            skel.add(this.currentSkeleton);
            this.currentSkeleton = null;
            this.currentDocumentPart = null;
        }
        skel.add(endMarker);
        if (endMarker != null && propertyTextUnitPlaceholders != null) {
            this.processAllEmbedded(endMarker.toString(), locale, propertyTextUnitPlaceholders, false);
        }
        this.popTempEvent();
        Ending eg = new Ending(this.groupId.getLastId());
        this.filterEvents.add(new Event(EventType.END_GROUP, eg, skel));
        return eg;
    }

    public void startCode(Code code) {
        this.codeStack.push(code);
    }

    public void endCode() {
        Code c;
        try {
            c = this.codeStack.pop();
        }
        catch (EmptyStackException e) {
            return;
        }
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu == null) {
            return;
        }
        tu.getSource().getFirstContent().append(c);
    }

    public void endCode(String tag) {
        Code c = null;
        try {
            c = this.codeStack.pop();
        }
        catch (EmptyStackException e) {
            throw new OkapiIllegalFilterOperationException("Trying to end a Code that does not exist. Did you call startCode?", e);
        }
        c.append(tag);
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu == null) {
            return;
        }
        tu.getSource().getFirstContent().append(c);
    }

    public void appendCodeOuterData(String outerData) {
        Code c = this.peekMostRecentCode();
        if (c != null) {
            c.appendOuterData(outerData);
        }
    }

    public void appendCodeData(String data) {
        Code c = this.peekMostRecentCode();
        if (c != null) {
            c.append(data);
        }
    }

    public void appendCodeInlineExcludedData(String data) {
        Code c = this.peekMostRecentCode();
        if (c != null) {
            c.append(data);
        } else {
            Code nc = new Code(TextFragment.TagType.PLACEHOLDER, "inline excluded");
            nc.append(data);
            this.codeStack.push(nc);
        }
    }

    public DocumentPart addDocumentPart(String part) {
        DocumentPart dp = this.startDocumentPart(part);
        this.endDocumentPart();
        return dp;
    }

    public DocumentPart startDocumentPart(String part) {
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        } else if (this.isCurrentTextUnit()) {
            this.endTextUnit();
        }
        this.currentSkeleton = new GenericSkeleton(part);
        this.currentDocumentPart = new DocumentPart(this.documentPartId.createId(), false);
        this.currentDocumentPart.setSkeleton(this.currentSkeleton);
        return this.currentDocumentPart;
    }

    public void startDocumentPart(String part, String name, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.startDocumentPart(part, name, null, propertyTextUnitPlaceholders);
    }

    public void startDocumentPart(String part, String name, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        } else if (this.isCurrentTextUnit()) {
            this.endTextUnit();
        }
        this.currentSkeleton = new GenericSkeleton();
        this.currentDocumentPart = new DocumentPart(this.documentPartId.createId(), false);
        this.currentDocumentPart.setSkeleton(this.currentSkeleton);
        this.processAllEmbedded(part, locale, propertyTextUnitPlaceholders, false);
    }

    public void endDocumentPart(String part) {
        if (part != null) {
            this.currentSkeleton.append(part);
        }
        this.filterEvents.add(new Event(EventType.DOCUMENT_PART, this.currentDocumentPart));
        this.currentSkeleton = null;
        this.currentDocumentPart = null;
    }

    public void endDocumentPart() {
        this.endDocumentPart(null);
    }

    public void addToDocumentPart(String part) {
        if (Util.isEmpty(part)) {
            return;
        }
        if (this.currentSkeleton == null) {
            this.startDocumentPart(part);
            return;
        }
        this.currentSkeleton.append(part);
    }

    public void addToDocumentPart(GenericSkeleton part) {
        if (part.isEmpty()) {
            return;
        }
        if (this.currentSkeleton == null) {
            if (this.hasUnfinishedSkeleton()) {
                this.endDocumentPart();
            } else if (this.isCurrentTextUnit()) {
                this.endTextUnit();
            }
            this.currentSkeleton = new GenericSkeleton(part);
            this.currentDocumentPart = new DocumentPart(this.documentPartId.createId(), false);
            this.currentDocumentPart.setSkeleton(this.currentSkeleton);
            return;
        }
        this.currentSkeleton.add(part);
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setTextUnitMimeType(String mimeType) {
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setMimeType(mimeType);
        }
    }

    public void setPreserveWhitespace(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }

    public void setTextUnitPreserveWhitespace(boolean preserveWhitespace) {
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setPreserveWhitespaces(preserveWhitespace);
        }
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public long getTextUnitId() {
        return this.textUnitId.getSequence();
    }

    public Code getCurrentCode() {
        return this.peekMostRecentCode();
    }

    public void setTextUnitId(long id) {
        this.textUnitId.setSequence(id);
    }

    public void setTextUnitName(String name) {
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setName(name);
        }
    }

    public void setTextUnitType(String type) {
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setType(type);
        }
    }

    public void setTextUnitTranslatable(boolean translatable) {
        ITextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setIsTranslatable(translatable);
        }
    }

    public long getDocumentPartId() {
        return this.documentPartId.getSequence();
    }

    public void setDocumentPartId(long id) {
        this.documentPartId.setSequence(id);
    }

    public String getRootId() {
        return this.rootId;
    }

    protected ITextUnit postProcessTextUnit(ITextUnit textUnit) {
        return textUnit;
    }

    public boolean isTextUnitWithSameType(String type) {
        ITextUnit tu;
        Event e = this.peekTempEvent();
        return e != null && e.getEventType() == EventType.TEXT_UNIT && (tu = e.getTextUnit()) != null && tu.getType() != null && tu.getType().equals(type);
    }

    public IdGenerator getGroupId() {
        return this.groupId;
    }

    public long getGroupIdSequence() {
        return this.groupId.getSequence();
    }

    public void setGroupIdSequence(long id) {
        this.groupId.setSequence(id);
    }

    public IdGenerator getSubDocumentId() {
        return this.subDocumentId;
    }
}

