/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.SubFilterEventConverter;
import net.sf.okapi.common.filters.SubFilterWrapper;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.SkeletonUtil;

public interface ISubFilter
extends IFilter {
    public static ISubFilter create(IFilter filter, IEncoder parentEncoder, int sectionIndex, String parentId, String parentName) {
        if (filter instanceof ISubFilter) {
            ((ISubFilter)filter).setParentId(parentId);
            ((ISubFilter)filter).setParentEncoder(parentEncoder);
            ((ISubFilter)filter).setParentName(parentName);
            ((ISubFilter)filter).setSectionIndex(sectionIndex);
            ((ISubFilter)filter).setParentType("");
            ((ISubFilter)filter).setConverter(new SubFilterEventConverter((ISubFilter)filter, parentEncoder));
            return (ISubFilter)filter;
        }
        return new SubFilterWrapper(filter, parentEncoder, sectionIndex, parentId, parentName);
    }

    public static ISubFilter create(IFilter filter, IEncoder parentEncoder) {
        return ISubFilter.create(filter, parentEncoder, 0, null, null);
    }

    public static boolean resourceIdsMatch(String startSubfilterResourceId, String endSubfilterResourceId) {
        if (startSubfilterResourceId == null || endSubfilterResourceId == null) {
            return false;
        }
        int i = ((String)startSubfilterResourceId).lastIndexOf("ssf");
        if (i != -1) {
            startSubfilterResourceId = ((String)startSubfilterResourceId).substring(0, i) + ((String)startSubfilterResourceId).substring(i + "ssf".length());
        }
        if ((i = ((String)endSubfilterResourceId).lastIndexOf("esf")) != -1) {
            endSubfilterResourceId = ((String)endSubfilterResourceId).substring(0, i) + ((String)endSubfilterResourceId).substring(i + "esf".length());
        }
        return ((String)startSubfilterResourceId).equals(endSubfilterResourceId);
    }

    default public Event createRefEvent() {
        return this.createRefEvent(null, null);
    }

    default public Event createRefEvent(IResource resource) {
        ISkeleton skel = resource.getSkeleton();
        if (skel instanceof GenericSkeleton) {
            GenericSkeleton[] parts = SkeletonUtil.splitSkeleton((GenericSkeleton)skel);
            return this.createRefEvent(parts[0], parts[1]);
        }
        if (skel != null) {
            throw new OkapiException("Unknown skeleton type.");
        }
        return this.createRefEvent();
    }

    default public Event createRefEvent(ISkeleton beforeSkeleton, ISkeleton afterSkeleton) {
        if (beforeSkeleton instanceof GenericSkeleton && afterSkeleton instanceof GenericSkeleton) {
            DocumentPart dp = this.buildRefDP((GenericSkeleton)beforeSkeleton, (GenericSkeleton)afterSkeleton);
            return new Event(EventType.DOCUMENT_PART, dp);
        }
        if (beforeSkeleton != null || afterSkeleton != null) {
            throw new OkapiException("Unknown skeleton type.");
        }
        DocumentPart dp = this.buildRefDP(null, null);
        return new Event(EventType.DOCUMENT_PART, dp);
    }

    private DocumentPart buildRefDP(GenericSkeleton beforeSkeleton, GenericSkeleton afterSkeleton) {
        GenericSkeleton skel = new GenericSkeleton();
        DocumentPart dp = new DocumentPart(this.buildRefId(), false, skel);
        skel.add(beforeSkeleton);
        skel.addReference(this.getStartSubfilter());
        this.getStartSubfilter().setIsReferent(true);
        skel.add(afterSkeleton);
        dp.setName(this.buildRefName());
        dp.setType("ref-ssf");
        return dp;
    }

    private String buildStartSubFilterId(String originalResId) {
        return originalResId != null ? String.format("%s_%s", this.getParentId(), originalResId) : String.format("%s_%s%d", this.getParentId(), "ssf", this.getSectionIndex());
    }

    private String buildStartSubFilterName() {
        return "sub-filter:" + this.getParentName();
    }

    private String buildEndSubFilterId(String originalResId) {
        return originalResId != null ? String.format("%s_%s", this.getParentId(), originalResId) : String.format("%s_%s%d", this.getParentId(), "esf", this.getSectionIndex());
    }

    default public String buildResourceId(String resId, Class<? extends IResource> resClass) {
        if (resClass == StartSubfilter.class) {
            return this.buildStartSubFilterId(resId);
        }
        if (resClass == EndSubfilter.class) {
            return this.buildEndSubFilterId(resId);
        }
        return String.format("%s_%s%d_%s", this.getParentId(), "sf", this.getSectionIndex(), resId);
    }

    default public String buildResourceName(String resName, boolean autoGenerated, Class<? extends INameable> resClass) {
        if (resClass == StartSubfilter.class) {
            return this.buildStartSubFilterName();
        }
        return autoGenerated ? String.format("%s_%s", this.getParentName(), resName) : resName;
    }

    private String buildRefId() {
        return String.format("ref-%s%s-%d", "sub-filter:", this.getParentId(), this.getSectionIndex());
    }

    private String buildRefName() {
        return "ref:" + this.getParentId();
    }

    public List<Event> getEvents(ITextUnit var1, LocaleId var2, LocaleId var3);

    public List<Event> getEvents(RawDocument var1);

    default public Code createRefCode() {
        this.getStartSubfilter().setIsReferent(true);
        Code c = new Code(TextFragment.TagType.PLACEHOLDER, this.getStartSubfilter().getName(), TextFragment.makeRefMarker(this.getStartSubfilter().getId()));
        c.setReferenceFlag(true);
        return c;
    }

    default public Code createSourceRefCode() {
        this.getStartSubfilter().setIsReferent(true);
        Code c = new Code(TextFragment.TagType.PLACEHOLDER, this.getStartSubfilter().getName(), TextFragment.makeRefMarker(this.getStartSubfilter().getId(), "source"));
        c.setReferenceFlag(true);
        return c;
    }

    default public Code createTargetRefCode() {
        this.getStartSubfilter().setIsReferent(true);
        Code c = new Code(TextFragment.TagType.PLACEHOLDER, this.getStartSubfilter().getName(), TextFragment.makeRefMarker(this.getStartSubfilter().getId(), "target"));
        c.setReferenceFlag(true);
        return c;
    }

    public StartSubfilter getStartSubfilter();

    public String getParentName();

    public int getSectionIndex();

    public String getParentId();

    public String getParentType();

    public void setParentId(String var1);

    public void setParentEncoder(IEncoder var1);

    public void setParentName(String var1);

    public void setSectionIndex(int var1);

    public void setParentType(String var1);

    public void setStartSubfilter(StartSubfilter var1);

    public void setEndSubfilter(EndSubfilter var1);

    public void setConverter(SubFilterEventConverter var1);

    public SubFilterEventConverter getConverter();
}

