/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.ISubFilter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonSimplifier;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;

public class SubFilterWrapperStep
extends BasePipelineStep
implements IPipelineStep {
    private final ISubFilter subFilter;
    private final IFilter primaryFilter;
    private int sectionIndex = 1;

    public SubFilterWrapperStep(IFilter filter, IFilter primaryFilter) {
        this.subFilter = ISubFilter.create(filter, primaryFilter.getEncoderManager());
        this.primaryFilter = primaryFilter;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return "Wrapper around a SubFilter that produces flat results";
    }

    @Override
    public Stream<Event> handleStream(Event event) {
        try {
            if (event.isTextUnit()) {
                ITextUnit tu = event.getTextUnit();
                this.subFilter.setSectionIndex(this.sectionIndex++);
                ArrayList<Event> allEvents = new ArrayList<Event>();
                for (Event tuEvent : this.processSkeleton(event.getTextUnit())) {
                    if (tuEvent.isTextUnit()) {
                        allEvents.addAll(this.subFilter.getEvents(tu, this.getSourceLocale(), this.getTargetLocale()));
                        continue;
                    }
                    allEvents.add(tuEvent);
                }
                Stream<Event> stream = Stream.of(allEvents.toArray(new Event[0]));
                return stream;
            }
        }
        catch (Exception e) {
            throw new OkapiException(String.format("Error in subfilter: %s processing %s", this.subFilter.getName(), event.toString()), e);
        }
        finally {
            this.subFilter.close();
        }
        return Stream.of(event);
    }

    private List<Event> processSkeleton(ITextUnit tu) {
        if (tu.getSkeleton() != null) {
            if (tu.getSkeleton() instanceof GenericSkeleton) {
                GenericSkeletonSimplifier rs = new GenericSkeletonSimplifier(this.primaryFilter.isMultilingual(), (GenericSkeletonWriter)this.primaryFilter.createSkeletonWriter(), this.getTargetLocale());
                return rs.convertToList(new Event(EventType.TEXT_UNIT, tu));
            }
            return Collections.singletonList(new Event(EventType.TEXT_UNIT, tu));
        }
        return Collections.singletonList(new Event(EventType.TEXT_UNIT, tu));
    }

    @Override
    public void close() {
        this.subFilter.close();
    }

    public ISubFilter getSubFilter() {
        return this.subFilter;
    }
}

