/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterInfo;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadSafeFilterConfigurationMapper
implements IFilterConfigurationMapper {
    private static final Logger logger = LoggerFactory.getLogger(ThreadSafeFilterConfigurationMapper.class);
    private final ThreadLocal<Map<String, FilterConfiguration>> configMap;

    public ThreadSafeFilterConfigurationMapper() {
        this.configMap = ThreadLocal.withInitial(ThreadSafeFilterConfigurationMapper::loadConfigs);
    }

    public ThreadSafeFilterConfigurationMapper(Supplier<Map<String, FilterConfiguration>> fcSupplier) {
        this.configMap = ThreadLocal.withInitial(fcSupplier);
    }

    private static Map<String, FilterConfiguration> loadConfigs() {
        return new ConcurrentSkipListMap<String, FilterConfiguration>();
    }

    private static IParameters createDefaultParameters(FilterConfiguration fc) {
        try (IFilter filter = ThreadSafeFilterConfigurationMapper.instantiateFilter(fc.filterClass);){
            IParameters params = filter.getParameters();
            if (fc.parameters != null) {
                params.fromString(fc.parameters.toString());
                IParameters iParameters = params;
                return iParameters;
            }
            if (fc.parametersLocation != null) {
                params.load(filter.getClass().getResourceAsStream(fc.parametersLocation), false);
                IParameters iParameters = params;
                return iParameters;
            }
            params.reset();
            IParameters iParameters = params;
            return iParameters;
        }
    }

    private static IFilter instantiateFilter(String filterClass) {
        try {
            return (IFilter)Thread.currentThread().getContextClassLoader().loadClass(filterClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate: " + filterClass, e);
        }
    }

    @Override
    public void addCustomConfiguration(String configId, IParameters parameters) {
        if (this.configMap.get().containsKey(configId)) {
            return;
        }
        FilterConfiguration fc = new FilterConfiguration();
        fc.custom = true;
        fc.configId = configId;
        String[] res = IFilterConfigurationMapper.splitFilterFromConfiguration(fc.configId);
        try (IFilter filter = this.createFilter(res[0]);){
            fc.filterClass = filter.getClass().getName();
            fc.mimeType = filter.getMimeType();
            fc.description = "Configuration " + fc.configId;
            fc.name = fc.configId;
            fc.parameters = filter.getParameters();
            fc.parameters.fromString(parameters.toString());
            this.configMap.get().putIfAbsent(fc.configId, fc);
            logger.debug("Added custom config: {} with parameters: {}", (Object)configId, (Object)parameters);
        }
    }

    @Override
    public void addCustomConfiguration(String configId, String parameters) {
        if (this.configMap.get().containsKey(configId)) {
            return;
        }
        FilterConfiguration fc = new FilterConfiguration();
        fc.custom = true;
        fc.configId = configId;
        String[] res = IFilterConfigurationMapper.splitFilterFromConfiguration(fc.configId);
        try (IFilter filter = this.createFilter(res[0]);){
            fc.filterClass = filter.getClass().getName();
            fc.mimeType = filter.getMimeType();
            fc.description = "Configuration " + fc.configId;
            fc.name = fc.configId;
            fc.parameters = filter.getParameters();
            fc.parameters.fromString(parameters);
            this.configMap.get().putIfAbsent(fc.configId, fc);
            logger.debug("Added custom config: {} with parameters: {}", (Object)configId, (Object)parameters);
        }
    }

    @Override
    public void addConfigurations(String filterClass) {
        try (IFilter filter = ThreadSafeFilterConfigurationMapper.instantiateFilter(filterClass);){
            List<FilterConfiguration> list = filter.getConfigurations();
            if (list == null || list.isEmpty()) {
                logger.warn("No configuration provided for '{}'", (Object)filterClass);
                return;
            }
            for (FilterConfiguration config : list) {
                if (this.configMap.get().containsKey(config.configId)) continue;
                config.parameters = ThreadSafeFilterConfigurationMapper.createDefaultParameters(config);
                if (config.filterClass == null) {
                    logger.warn("Configuration without filter class name in '{}'", (Object)config);
                    config.filterClass = filterClass;
                }
                if (config.name == null) {
                    logger.warn("Configuration without name in '{}'", (Object)config);
                    config.name = config.toString();
                }
                if (config.description == null) {
                    logger.warn("Configuration without description in '{}'", (Object)config);
                    config.description = config.toString();
                }
                this.configMap.get().putIfAbsent(config.configId, config);
                logger.debug("Added custom config: {} with parameters: {}", (Object)config.configId, (Object)config.parameters);
            }
        }
    }

    @Override
    public void addConfiguration(FilterConfiguration config) {
        this.configMap.get().putIfAbsent(config.configId, config);
        logger.debug("Added custom config: {} with parameters: {}", (Object)config.configId, (Object)config.parameters);
    }

    @Override
    @Deprecated
    public IFilter createFilter(String configId, IFilter existingFilter) {
        FilterConfiguration fc = this.getConfiguration(configId);
        if (fc == null) {
            logger.error("Cannot find filter configuration '{}'", (Object)configId);
            return null;
        }
        try (IFilter filter = ThreadSafeFilterConfigurationMapper.instantiateFilter(fc.filterClass);){
            filter.setFilterConfigurationMapper(this);
            IParameters params = filter.getParameters();
            if (params != null) {
                params.fromString(fc.parameters.toString());
                filter.setParameters(params);
            }
            IFilter iFilter = filter;
            return iFilter;
        }
    }

    @Override
    public void clearConfigurations(boolean customOnly) {
        if (customOnly) {
            this.configMap.get().values().removeIf(fc -> fc.custom);
        } else {
            this.configMap.get().clear();
        }
    }

    @Override
    public IFilter createFilter(String configId) {
        return this.createFilter(configId, null);
    }

    @Override
    public FilterConfiguration getConfiguration(String configId) {
        Map<String, FilterConfiguration> cm = this.configMap.get();
        if (cm == null) {
            throw new IllegalStateException("No filter configurations have been loaded loaded");
        }
        return cm.get(configId);
    }

    @Override
    public FilterConfiguration getDefaultConfiguration(String mimeType) {
        FilterConfiguration autoXliff = this.getConfiguration("okf_autoxliff");
        if (autoXliff != null && autoXliff.mimeType.equals(mimeType)) {
            return autoXliff;
        }
        FilterConfiguration defaultConfig = null;
        for (FilterConfiguration config : this.configMap.get().values()) {
            if (config.mimeType == null || !config.mimeType.equals(mimeType)) continue;
            if (config.parametersLocation == null) {
                return config;
            }
            if (defaultConfig != null) continue;
            defaultConfig = config;
        }
        return defaultConfig;
    }

    @Override
    public FilterConfiguration getDefaultConfigurationFromExtension(String ext) {
        FilterConfiguration autoXliff;
        Object tmp = ext.toLowerCase() + ";";
        if (((String)tmp).charAt(0) != '.') {
            tmp = ".".concat((String)tmp);
        }
        if ((autoXliff = this.getConfiguration("okf_autoxliff")) != null && autoXliff.extensions.contains((CharSequence)tmp)) {
            return autoXliff;
        }
        for (FilterConfiguration config : this.configMap.get().values()) {
            String configExtensions;
            if (config.extensions == null || !(configExtensions = config.extensions + ";").contains((CharSequence)tmp)) continue;
            return config;
        }
        return null;
    }

    @Override
    public IParameters getParameters(FilterConfiguration config) {
        return config.parameters;
    }

    @Override
    public IParameters getParameters(FilterConfiguration config, IFilter existingFilter) {
        IFilter filter = this.createFilter(config.configId, existingFilter);
        return filter.getParameters();
    }

    @Override
    public FilterConfiguration createCustomConfiguration(FilterConfiguration baseConfig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IParameters getCustomParameters(FilterConfiguration config, IFilter existingFilter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IParameters getCustomParameters(FilterConfiguration config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<FilterConfiguration> getAllConfigurations() {
        return this.configMap.get().values().iterator();
    }

    @Override
    public List<FilterConfiguration> getFilterConfigurations(String filterClass) {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        for (FilterConfiguration config : this.configMap.get().values()) {
            if (config.filterClass == null || !config.filterClass.equals(filterClass)) continue;
            list.add(config);
        }
        return list;
    }

    @Override
    public IParametersEditor createConfigurationEditor(String configId, IFilter existingFilter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IParametersEditor createConfigurationEditor(String configId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FilterInfo> getFiltersInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FilterConfiguration> getMimeConfigurations(String mimeType) {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        for (FilterConfiguration config : this.configMap.get().values()) {
            if (config.mimeType == null || !config.mimeType.equals(mimeType)) continue;
            list.add(config);
        }
        return list;
    }

    @Override
    public void removeConfiguration(String configId) {
        this.configMap.get().remove(configId);
    }

    @Override
    public Iterator<FilterConfiguration> iterator() {
        return this.configMap.get().values().iterator();
    }

    @Override
    public void forEach(Consumer<? super FilterConfiguration> action) {
        this.configMap.get().values().forEach(action);
    }

    @Override
    public Spliterator<FilterConfiguration> spliterator() {
        return this.configMap.get().values().spliterator();
    }

    @Override
    public void removeConfigurations(String filterClass) {
        Iterator<Map.Entry<String, FilterConfiguration>> iter = this.configMap.get().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, FilterConfiguration> entry = iter.next();
            if (!entry.getValue().filterClass.equals(filterClass)) continue;
            iter.remove();
        }
    }

    @Override
    public void saveCustomParameters(FilterConfiguration config, IParameters params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteCustomParameters(FilterConfiguration config) {
        throw new UnsupportedOperationException();
    }

    public static class ConfigBuilder {
        private final Map<String, FilterConfiguration> configs = new HashMap<String, FilterConfiguration>();

        public ConfigBuilder addConfigurations(Class<? extends IFilter> filterClass) {
            try {
                try (IFilter filter = ThreadSafeFilterConfigurationMapper.instantiateFilter(filterClass.getCanonicalName());){
                    for (FilterConfiguration config : filter.getConfigurations()) {
                        if (this.configs.containsKey(config.configId)) continue;
                        config.parameters = ThreadSafeFilterConfigurationMapper.createDefaultParameters(config);
                        this.configs.put(config.configId, config);
                    }
                }
                return this;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't add configurations for " + filterClass.getName(), e);
            }
        }

        public ConfigBuilder addCustomConfiguration(String configId, String params) {
            try {
                String[] parts = IFilterConfigurationMapper.splitFilterFromConfiguration(configId);
                FilterConfiguration baseFilter = this.configs.get(parts[0]);
                if (baseFilter == null) {
                    throw new IllegalArgumentException("Couldn't find base filter for " + configId);
                }
                FilterConfiguration fc = new FilterConfiguration();
                fc.configId = configId;
                fc.filterClass = baseFilter.filterClass;
                fc.mimeType = baseFilter.mimeType;
                fc.description = baseFilter.description;
                fc.name = baseFilter.name;
                fc.parameters = ThreadSafeFilterConfigurationMapper.createDefaultParameters(baseFilter);
                fc.parameters.fromString(params);
                this.configs.putIfAbsent(configId, fc);
                return this;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't add custom configurations for " + configId);
            }
        }

        public ConfigBuilder updateConfiguration(String configId, String params) {
            try {
                String[] parts = IFilterConfigurationMapper.splitFilterFromConfiguration(configId);
                FilterConfiguration baseFilter = this.configs.get(parts[0]);
                if (baseFilter == null) {
                    throw new IllegalArgumentException("Couldn't find base filter for " + configId);
                }
                FilterConfiguration fc = this.configs.get(configId);
                if (fc == null) {
                    throw new IllegalArgumentException("Couldn't find filter configuration for " + configId);
                }
                fc.parameters.fromString(params);
                this.configs.put(configId, fc);
                return this;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't update configurations for " + configId);
            }
        }

        public ConfigBuilder updateConfigurations(Function<IParameters, IParameters> function) {
            for (FilterConfiguration config : this.configs.values()) {
                config.parameters = function.apply(config.parameters);
            }
            return this;
        }

        public Map<String, FilterConfiguration> build() {
            return Collections.synchronizedMap(this.configs);
        }
    }
}

