/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;

public class XLIFFWriterParameters
extends StringParameters {
    private static final String USESOURCEFORTRANSLATED = "useSourceForTranslated";
    private static final String ESCAPEGT = "escapeGt";
    private static final String PLACEHOLDERMODE = "placeholderMode";
    private static final String SETAPPROVEDASNOTRANSLATE = "setApprovedAsNoTranslate";
    public static final String COPYSOURCE = "copySource";
    private static final String INCLUDEALTTRANS = "includeAltTrans";
    private static final String INCLUDECODEATTRS = "includeCodeAttrs";
    private static final String INCLUDEITS = "includeIts";
    private static final String CREATEEMPTYTARGET = "createEmptyTarget";
    private static final String TOOL_ID = "toolId";
    private static final String TOOL_NAME = "toolName";
    private static final String TOOL_VERSION = "toolVersion";
    private static final String TOOL_COMPANY = "toolCompany";
    private static final String CUSTOM_TOOL_XML_SNIPPET = "customToolXmlSnippet";

    public boolean getUseSourceForTranslated() {
        return this.getBoolean(USESOURCEFORTRANSLATED);
    }

    public void setUseSourceForTranslated(boolean useSourceForTranslated) {
        this.setBoolean(USESOURCEFORTRANSLATED, useSourceForTranslated);
    }

    public boolean getEscapeGt() {
        return this.getBoolean(ESCAPEGT);
    }

    public void setEscapeGt(boolean escapeGt) {
        this.setBoolean(ESCAPEGT, escapeGt);
    }

    public boolean getPlaceholderMode() {
        return this.getBoolean(PLACEHOLDERMODE);
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.setBoolean(PLACEHOLDERMODE, placeholderMode);
    }

    public boolean getSetApprovedAsNoTranslate() {
        return this.getBoolean(SETAPPROVEDASNOTRANSLATE);
    }

    public void setSetApprovedAsNoTranslate(boolean setApprovedAsNoTranslate) {
        this.setBoolean(SETAPPROVEDASNOTRANSLATE, setApprovedAsNoTranslate);
    }

    public boolean getCopySource() {
        return this.getBoolean(COPYSOURCE);
    }

    public void setCopySource(boolean copySource) {
        this.setBoolean(COPYSOURCE, copySource);
    }

    public boolean getIncludeAltTrans() {
        return this.getBoolean(INCLUDEALTTRANS);
    }

    public void setIncludeAltTrans(boolean includeAltTrans) {
        this.setBoolean(INCLUDEALTTRANS, includeAltTrans);
    }

    public boolean getIncludeCodeAttrs() {
        return this.getBoolean(INCLUDECODEATTRS);
    }

    public void setIncludeCodeAttrs(boolean includeCodeAttrs) {
        this.setBoolean(INCLUDECODEATTRS, includeCodeAttrs);
    }

    public boolean getIncludeIts() {
        return this.getBoolean(INCLUDEITS);
    }

    public void setIncludeIts(boolean includeIts) {
        this.setBoolean(INCLUDEITS, includeIts);
    }

    public String getToolId() {
        return this.getString(TOOL_ID);
    }

    public void setToolId(String toolId) {
        this.setString(TOOL_ID, toolId);
    }

    public String getToolName() {
        return this.getString(TOOL_NAME);
    }

    public void setToolName(String toolName) {
        this.setString(TOOL_NAME, toolName);
    }

    public String getToolVersion() {
        return this.getString(TOOL_VERSION);
    }

    public void setToolVersion(String toolVersion) {
        this.setString(TOOL_VERSION, toolVersion);
    }

    public String getToolCompany() {
        return this.getString(TOOL_COMPANY);
    }

    public void setToolCompany(String toolCompany) {
        this.setString(TOOL_COMPANY, toolCompany);
    }

    public String getToolXmlSnippet() {
        return this.getString(CUSTOM_TOOL_XML_SNIPPET);
    }

    public void setToolXmlSnippet(String snippet) {
        this.setString(CUSTOM_TOOL_XML_SNIPPET, snippet);
    }

    public boolean getCreateEmptyTarget() {
        return this.getBoolean(CREATEEMPTYTARGET);
    }

    public void setCreateEmptyTarget(boolean createEmptyTarget) {
        this.setBoolean(CREATEEMPTYTARGET, createEmptyTarget);
    }

    @Override
    public void reset() {
        super.reset();
        this.setUseSourceForTranslated(false);
        this.setEscapeGt(false);
        this.setPlaceholderMode(true);
        this.setSetApprovedAsNoTranslate(false);
        this.setCopySource(false);
        this.setIncludeAltTrans(true);
        this.setIncludeCodeAttrs(false);
        this.setIncludeIts(true);
        this.setToolId(null);
        this.setToolName(null);
        this.setToolVersion(null);
        this.setToolCompany(null);
        this.setToolXmlSnippet(null);
        this.setCreateEmptyTarget(true);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USESOURCEFORTRANSLATED, "Use the source text in the target, even if a target is available", null);
        desc.add(ESCAPEGT, "Escape the greater-than characters as &gt;", null);
        desc.add(PLACEHOLDERMODE, "Inline code should use the place-holder notation (g and x elements)", null);
        desc.add(SETAPPROVEDASNOTRANSLATE, "Mark as not translatable all entries that are approved", null);
        desc.add(COPYSOURCE, "Copy the source as target if there is no target defined", null);
        desc.add(CREATEEMPTYTARGET, "Create an empty target even if no target exists in the original", null);
        desc.add(INCLUDEALTTRANS, "Output alt-trans elements", null);
        desc.add(INCLUDECODEATTRS, "Output extended code attributes", null);
        desc.add(INCLUDEITS, "Output ITS markup", null);
        desc.add(TOOL_ID, "Xliff Tool Id Value", "Tool Id is used in the xliff tool element found in the header");
        desc.add(TOOL_NAME, "Xliff Tool Name Value", "Tool Name is used in the xliff tool element found in the header");
        desc.add(TOOL_VERSION, "Xliff Tool Version Value", "Tool Version is used in the xliff tool element found in the header");
        desc.add(TOOL_COMPANY, "Xliff Tool Company Name Value", "Tool Company Name is used in the xliff tool element found in the header");
        desc.add(CUSTOM_TOOL_XML_SNIPPET, "Custom Tool XML Snippet", "Custom Tool XML snippet containing company or tool specific metadata. Written as part of the Xliff tool element (tool-id and tool-name must be defined!). Must be well-formed XML with a valid namespace URI");
        return desc;
    }
}

