/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;

public interface IPipelineStep
extends AutoCloseable,
Function<Stream<Event>, Stream<Event>> {
    public static <T> T runPipelineSteps(List<Function<T, T>> functions, T t) {
        return functions.stream().reduce(Function.identity(), Function::andThen).apply(t);
    }

    public IParameters getParameters();

    public void setParameters(IParameters var1);

    public String getName();

    public String getDescription();

    public String getHelpLocation();

    public Event handleEvent(Event var1);

    default public Stream<Event> handleStream(Event event) {
        this.handleEvent(event);
        return Stream.of(event);
    }

    @Override
    default public Stream<Event> apply(Stream<Event> events) {
        return events.flatMap(this::handleStream);
    }

    public boolean isDone();

    @Deprecated
    default public void destroy() {
    }

    @Override
    default public void close() {
        this.destroy();
    }

    public void cancel();

    public boolean isLastOutputStep();

    public void setLastOutputStep(boolean var1);

    default public LocaleId getSourceLocale() {
        return null;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    default public void setSourceLocale(LocaleId sourceLocale) {
    }

    default public LocaleId getTargetLocale() {
        return null;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    default public void setTargetLocale(LocaleId targetLocale) {
    }
}

