/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import net.sf.okapi.common.ClassInfo;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.DefaultFilenameFilter;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IEmbeddableParametersEditor;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.plugins.PluginItem;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class PluginsManager {
    private ArrayList<URL> urls = new ArrayList();
    private List<PluginItem> plugins = new ArrayList<PluginItem>();
    private URLClassLoader loader;
    private File pluginsDir;
    private ClassLoader parentClassLoader = null;

    public PluginsManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public PluginsManager(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public void discover(File pluginsDir, boolean append) {
        try {
            File[] files;
            if (pluginsDir == null) {
                return;
            }
            if (!pluginsDir.isDirectory()) {
                return;
            }
            this.pluginsDir = pluginsDir;
            if (!append) {
                this.urls.clear();
            }
            this.loader = null;
            DefaultFilenameFilter filter = new DefaultFilenameFilter(".jar");
            for (File file : files = pluginsDir.listFiles(filter)) {
                if (file.isDirectory()) continue;
                this.inspectFile(file);
            }
            File[] dirs = pluginsDir.listFiles();
            for (File dir : dirs) {
                if (!dir.isDirectory()) continue;
                files = dir.listFiles(filter);
                for (File file : files) {
                    this.inspectFile(file);
                }
            }
            if (!this.urls.isEmpty()) {
                URL[] tmp = this.urls.toArray(new URL[0]);
                this.loader = AccessController.doPrivileged(() -> new URLClassLoader(tmp, this.parentClassLoader));
            }
            block17: for (PluginItem item1 : this.plugins) {
                Class<?> cls1 = Class.forName(item1.className, false, this.loader);
                switch (item1.type) {
                    case 1: 
                    case 2: 
                    case 32: {
                        UsingParameters usingParams = cls1.getAnnotation(UsingParameters.class);
                        if (usingParams == null || usingParams.value().equals(IParameters.class)) continue block17;
                        for (PluginItem item2 : this.plugins) {
                            switch (item2.type) {
                                case 4: 
                                case 8: 
                                case 16: {
                                    Class<?> cls2 = Class.forName(item2.className, false, this.loader);
                                    EditorFor editorFor = cls2.getAnnotation(EditorFor.class);
                                    if (editorFor == null) break;
                                    if (editorFor.value().equals(usingParams.value())) {
                                        if (IParametersEditor.class.isAssignableFrom(cls2)) {
                                            item1.paramsEditor = new ClassInfo(item2.className, this.loader);
                                        }
                                        if (IEmbeddableParametersEditor.class.isAssignableFrom(cls2)) {
                                            item1.embeddableParamsEditor = new ClassInfo(item2.className, this.loader);
                                        }
                                        if (IEditorDescriptionProvider.class.isAssignableFrom(cls2)) {
                                            item1.editorDescriptionProvider = new ClassInfo(item2.className, this.loader);
                                        }
                                    }
                                    cls2 = null;
                                }
                            }
                        }
                        break;
                    }
                }
                cls1 = null;
            }
        }
        catch (ClassNotFoundException e) {
            throw new OkapiException("Class not found", e);
        }
        catch (SecurityException e) {
            throw new OkapiException("Error when looking for getParameters() method.", e);
        }
        finally {
            System.gc();
        }
    }

    public List<String> getList(int type) {
        ArrayList<String> list = new ArrayList<String>();
        for (PluginItem item : this.plugins) {
            if (item.type != type) continue;
            list.add(item.className);
        }
        return list;
    }

    public List<PluginItem> getList() {
        return this.plugins;
    }

    public ArrayList<URL> getURLs() {
        return this.urls;
    }

    public URLClassLoader getClassLoader() {
        return this.loader;
    }

    private void inspectFile(File file) {
        try {
            if (file == null || !file.exists()) {
                return;
            }
            URL url = file.toURI().toURL();
            URL[] tmpUrls = new URL[]{url};
            URLClassLoader loader = URLClassLoader.newInstance(tmpUrls, this.parentClassLoader);
            FileInputStream fis = new FileInputStream(file);
            JarInputStream jarFile = new JarInputStream(fis);
            Class<?> cls = null;
            while (true) {
                cls = null;
                JarEntry entry = jarFile.getNextJarEntry();
                if (entry == null) break;
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                name = name.substring(0, name.length() - 6).replace('/', '.');
                try {
                    cls = Class.forName(name, false, loader);
                    if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) continue;
                    if (IFilter.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(UsingParameters.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(1, name));
                    } else if (IPipelineStep.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(UsingParameters.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(2, name));
                    } else if (IParametersEditor.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(EditorFor.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(4, name));
                    } else if (IEmbeddableParametersEditor.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(EditorFor.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(8, name));
                    } else if (IEditorDescriptionProvider.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(EditorFor.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(16, name));
                    } else if (IQuery.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(UsingParameters.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(32, name));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                cls = null;
            }
            if (jarFile != null) {
                jarFile.close();
                jarFile = null;
                fis.close();
                fis = null;
                file = null;
            }
            cls = null;
            loader = null;
        }
        catch (IOException e) {
            throw new OkapiException("IO error when inspecting a file for plugins.", e);
        }
    }

    public File getPluginsDir() {
        return this.pluginsDir;
    }

    public void releaseClassLoader() {
        PluginsManager.closeOpenJars(this.loader);
        this.loader = null;
    }

    public static void closeOpenJars(ClassLoader classLoader) {
        if (!(classLoader instanceof URLClassLoader)) {
            return;
        }
        try {
            Class<URLClassLoader> clazz = URLClassLoader.class;
            Field ucp = clazz.getDeclaredField("ucp");
            ucp.setAccessible(true);
            Object sun_misc_URLClassPath = ucp.get(classLoader);
            Field loaders = sun_misc_URLClassPath.getClass().getDeclaredField("loaders");
            loaders.setAccessible(true);
            Object java_util_Collection = loaders.get(sun_misc_URLClassPath);
            for (Object sun_misc_URLClassPath_JarLoader : ((Collection)java_util_Collection).toArray()) {
                try {
                    Field loader = sun_misc_URLClassPath_JarLoader.getClass().getDeclaredField("jar");
                    loader.setAccessible(true);
                    Object java_util_jar_JarFile = loader.get(sun_misc_URLClassPath_JarLoader);
                    JarFile jarFile = (JarFile)java_util_jar_JarFile;
                    jarFile.close();
                    PluginsManager.cleanupJarFileFactory(jarFile.getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean cleanupJarFileFactory(String ... jarNames) {
        List<String> setJarFileNames2Close = ListUtil.arrayAsList(jarNames);
        boolean res = false;
        Class<?> classJarURLConnection = null;
        classJarURLConnection = ClassUtil.getClass("sun.net.www.protocol.jar.JarURLConnection");
        if (classJarURLConnection == null) {
            return res;
        }
        Field f = null;
        try {
            f = classJarURLConnection.getDeclaredField("factory");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (f == null) {
            return res;
        }
        f.setAccessible(true);
        Object tmpObj = null;
        try {
            tmpObj = f.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (tmpObj == null) {
            return res;
        }
        Class<?> classJarFileFactory = tmpObj.getClass();
        HashMap fileCache = null;
        try {
            f = classJarFileFactory.getDeclaredField("fileCache");
            f.setAccessible(true);
            Object obj = f.get(null);
            if (obj instanceof HashMap) {
                fileCache = (HashMap)obj;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException obj) {
            // empty catch block
        }
        HashMap urlCache = null;
        try {
            f = classJarFileFactory.getDeclaredField("urlCache");
            f.setAccessible(true);
            Object obj = f.get(null);
            if (obj instanceof HashMap) {
                urlCache = (HashMap)obj;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException obj) {
            // empty catch block
        }
        if (urlCache != null) {
            HashMap urlCacheTmp = (HashMap)urlCache.clone();
            for (Object obj : urlCacheTmp.keySet()) {
                JarFile jarFile;
                if (!(obj instanceof JarFile) || !setJarFileNames2Close.contains((jarFile = (JarFile)obj).getName())) continue;
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (fileCache != null) {
                    fileCache.remove(urlCache.get(jarFile));
                }
                urlCache.remove(jarFile);
            }
            res = true;
        } else if (fileCache != null) {
            HashMap fileCacheTmp = (HashMap)fileCache.clone();
            for (Object key : fileCacheTmp.keySet()) {
                JarFile jarFile;
                Object obj = fileCache.get(key);
                if (!(obj instanceof JarFile) || !setJarFileNames2Close.contains((jarFile = (JarFile)obj).getName())) continue;
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                fileCache.remove(key);
            }
            res = true;
        }
        setJarFileNames2Close.clear();
        return res;
    }
}

