/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CodeTypeBuilder {
    private static final String EMPTY_VALUE = "";
    private static final String VALUES_DELIMITER = ",";
    private final Set<String> codeTypes;
    private final Map<String, String> codeTypesAndValues;
    private final boolean addExtendedCodeTypePrefix;

    public CodeTypeBuilder(boolean addExtendedCodeTypePrefix) {
        this(new LinkedHashSet<String>(), new LinkedHashMap<String, String>(), addExtendedCodeTypePrefix);
    }

    public CodeTypeBuilder(Set<String> codeTypes, Map<String, String> codeTypesAndValues, boolean addExtendedCodeTypePrefix) {
        this.codeTypes = codeTypes;
        this.codeTypesAndValues = codeTypesAndValues;
        this.addExtendedCodeTypePrefix = addExtendedCodeTypePrefix;
    }

    public void addType(String type) {
        this.codeTypes.add(type);
    }

    public void addType(String type, String value) {
        String currentValue = this.codeTypesAndValues.get(type);
        if (null == currentValue) {
            this.codeTypesAndValues.put(type, value);
        } else {
            LinkedHashSet<String> values = new LinkedHashSet<String>(Arrays.asList(currentValue.split(VALUES_DELIMITER)));
            if (!values.contains(value)) {
                values.add(value);
                this.codeTypesAndValues.put(type, String.join((CharSequence)VALUES_DELIMITER, values));
            }
        }
    }

    public String build() {
        if (this.codeTypes.isEmpty() && this.codeTypesAndValues.isEmpty()) {
            return EMPTY_VALUE;
        }
        StringBuilder codeTypeBuilder = new StringBuilder(this.addExtendedCodeTypePrefix ? "x-" : EMPTY_VALUE);
        for (String string : this.codeTypes) {
            codeTypeBuilder.append(string).append(";");
        }
        for (Map.Entry entry : this.codeTypesAndValues.entrySet()) {
            codeTypeBuilder.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(";");
        }
        return codeTypeBuilder.toString();
    }
}

