/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.EnumSet;
import java.util.Objects;

public class Property
implements Cloneable {
    public static final String ENCODING = "encoding";
    public static final String LANGUAGE = "language";
    public static final String APPROVED = "approved";
    public static final String COORDINATES = "coordinates";
    public static final String STATE_QUALIFIER = "state-qualifier";
    public static final String STATE = "state";
    public static final String ITS_LQI = "locQualityIssuesRef";
    public static final String ITS_PROV = "provenanceRecordsRef";
    public static final String ITS_MTCONFIDENCE = "mtConfidence";
    public static final String XLIFF_TOOL = "tool";
    public static final String XLIFF_PHASE = "phase";
    public static final String MAX_WIDTH = "maxwidth";
    public static final String MAX_HEIGHT = "maxheight";
    public static final String SIZE_UNIT = "size-unit";
    public static final String TMX_i = "TMX_i";
    public static String TMX_hi = "TMX_hi";
    public static String TMX_x = "TMX_x";
    public static EnumSet<Type> FILTER_AND_DISPLAY = EnumSet.of(Type.FILTER_ONLY, Type.DISPLAY);
    public static EnumSet<Type> DISPLAY_ONLY = EnumSet.of(Type.DISPLAY);
    private String name;
    private String value;
    private boolean isReadOnly;
    private EnumSet<Type> types;

    public Property(String name, String value, boolean isReadOnly) {
        this.name = name;
        this.value = value;
        this.isReadOnly = isReadOnly;
        this.types = EnumSet.of(Type.FILTER_ONLY);
    }

    public Property(String name, String value, boolean isReadOnly, EnumSet<Type> type) {
        this(name, value, isReadOnly);
        this.types = type;
    }

    public Property(String name, String value) {
        this(name, value, true);
    }

    public Property(String name, String value, EnumSet<Type> type) {
        this(name, value, true);
        this.types = type;
    }

    public String toString() {
        return this.value;
    }

    public Property clone() {
        return new Property(this.name, this.value, this.isReadOnly);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean getBoolean() {
        if (this.value == null) {
            return false;
        }
        return this.value.equalsIgnoreCase("yes") || this.value.equalsIgnoreCase("true");
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    protected void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public EnumSet<Type> getTypes() {
        return this.types;
    }

    public void setTypes(EnumSet<Type> types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        return this.isReadOnly() == property.isReadOnly() && Objects.equals(this.getName(), property.getName()) && Objects.equals(this.getValue(), property.getValue()) && Objects.equals(this.getTypes(), property.getTypes());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getValue(), this.isReadOnly(), this.getTypes());
    }

    public static enum Type {
        FILTER_ONLY("filter-only"),
        DISPLAY("display"),
        ITS("its"),
        PIPELINE("pipeline");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

