/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.apertium;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String SERVER = "server";
    private static final String APIKEY = "apiKey";
    private static final String TIMEOUT = "timeout";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    @Override
    public void reset() {
        super.reset();
        this.setServer("https://apertium.org/apy");
        this.setApiKey("");
        this.setTimeout(0);
    }

    public String getServer() {
        return this.getString(SERVER);
    }

    public void setServer(String server) {
        this.setString(SERVER, server);
    }

    public String getApiKey() {
        return this.getString(APIKEY);
    }

    public void setApiKey(String apiKey) {
        this.setString(APIKEY, apiKey);
    }

    public int getTimeout() {
        return this.getInteger(TIMEOUT);
    }

    public void setTimeout(int timeout) {
        this.setInteger(TIMEOUT, timeout);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SERVER, "Server URL:", "Full URL of the server");
        desc.add(APIKEY, "API Key:", "Recommended key (See http://api.apertium.org/register.jsp)");
        desc.add(TIMEOUT, "Timeout", "Timeout in second after which to give up (use 0 for system timeout)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Apertium MT Connector Settings");
        desc.addTextInputPart(paramsDesc.get(SERVER));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(APIKEY));
        tip.setPassword(true);
        tip.setAllowEmpty(true);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(TIMEOUT));
        sip.setRange(0, 60);
        return desc;
    }
}

