/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.microsoft.FragmentQueryResultBuilder;
import net.sf.okapi.connectors.microsoft.GetTranslationsArrayRequest;
import net.sf.okapi.connectors.microsoft.MicrosoftMTAPI;
import net.sf.okapi.connectors.microsoft.MicrosoftMTAPIv3Impl;
import net.sf.okapi.connectors.microsoft.Parameters;
import net.sf.okapi.connectors.microsoft.QueryResultBuilder;
import net.sf.okapi.connectors.microsoft.TextQueryResultBuilder;
import net.sf.okapi.connectors.microsoft.TranslationResponse;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryUtil;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class MicrosoftMTConnector
extends BaseConnector
implements ITMQuery {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int RETRIES = 5;
    private static final int SLEEPPAUSE = 300;
    static final int CONNECTION_TIMEOUT = 20000;
    private QueryUtil util = new QueryUtil();
    private Parameters params = new Parameters();
    private int maximumHits = 1;
    private int threshold = -10;
    private Iterator<QueryResult> results = Collections.emptyIterator();
    private MicrosoftMTAPI api;
    private CloseableHttpClient httpClient;

    public MicrosoftMTConnector() {
        this(HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(20000).setSocketTimeout(20000).build()).build());
    }

    public MicrosoftMTConnector(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "Microsoft-Translator";
    }

    @Override
    public String getSettingsDisplay() {
        return "Service: " + this.params.getBaseURL();
    }

    @Override
    public void open() {
        this.open(null);
    }

    void open(MicrosoftMTAPI api) {
        this.results = Collections.emptyIterator();
        this.api = api != null ? api : new MicrosoftMTAPIv3Impl(this.getParameters(), (HttpClient)this.httpClient);
    }

    protected <T> int _query(String queryText, T originalText, QueryResultBuilder<T> resultBuilder) {
        this.open(this.api);
        if (queryText.trim().isEmpty()) {
            return 0;
        }
        List<Object> queryResults = new ArrayList();
        try {
            for (int tries = 0; tries < 5; ++tries) {
                List<TranslationResponse> responses = this.api.getTranslations(queryText, this.srcCode, this.trgCode, this.maximumHits, this.threshold);
                if (responses != null) {
                    queryResults = resultBuilder.convertResponses(responses, originalText);
                    break;
                }
                try {
                    Thread.sleep(300L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new OkapiException("Interrupted while trying to contact Microsoft MT");
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the MT server.\n" + e.getMessage(), e);
        }
        if (!queryResults.isEmpty()) {
            this.results = queryResults.iterator();
            return queryResults.size();
        }
        throw new OkapiException("Could not retrieve results from Microsoft MT after 5 attempts.");
    }

    @Override
    public int query(String plainText) {
        return this._query(plainText, plainText, new TextQueryResultBuilder(this.params, this.getWeight()));
    }

    @Override
    public int query(TextFragment frag) {
        return this._query(this.util.toCodedHTML(frag), frag, new FragmentQueryResultBuilder(this.params, this.getWeight()));
    }

    protected <T> List<List<QueryResult>> _batchQuery(List<String> texts, List<T> originalText, QueryResultBuilder<T> qrBuilder) {
        this.open(this.api);
        int batchCharCount = 0;
        ArrayList<List<QueryResult>> results = new ArrayList<List<QueryResult>>(texts.size());
        ArrayList<String> textsToQuery = new ArrayList<String>();
        ArrayList<T> originalTextsToQuery = new ArrayList<T>();
        for (int end = 0; end < texts.size(); ++end) {
            int charCount = texts.get(end).trim().length();
            if (charCount >= this.api.maxCharCount()) {
                this.logger.warn("Segment {} starting with '{}' is too long to query.", (Object)end, (Object)texts.get(end).substring(0, 20));
                continue;
            }
            if (charCount < 1) {
                this.logger.warn("Segment {} is empty or contains only whitespace.", (Object)end);
                continue;
            }
            boolean processBatch = false;
            if (batchCharCount + charCount >= this.api.maxCharCount()) {
                processBatch = true;
            }
            if (textsToQuery.size() >= this.api.maxTextCount()) {
                processBatch = true;
            }
            if (processBatch) {
                results.addAll(this._subBatchQuery(textsToQuery, originalTextsToQuery, qrBuilder));
                batchCharCount = 0;
                textsToQuery.clear();
                originalTextsToQuery.clear();
                --end;
                continue;
            }
            batchCharCount += charCount;
            textsToQuery.add(texts.get(end).trim());
            originalTextsToQuery.add(originalText.get(end));
        }
        if (!textsToQuery.isEmpty()) {
            results.addAll(this._subBatchQuery(textsToQuery, originalTextsToQuery, qrBuilder));
        }
        return results;
    }

    protected <T> List<List<QueryResult>> _subBatchQuery(List<String> texts, List<T> originalText, QueryResultBuilder<T> qrBuilder) {
        GetTranslationsArrayRequest request = new GetTranslationsArrayRequest(texts, this.srcCode, this.trgCode, this.maximumHits, this.params.getCategory());
        ArrayList<List<QueryResult>> queryResults = new ArrayList<List<QueryResult>>();
        for (int tries = 0; tries < 5; ++tries) {
            List<List<TranslationResponse>> responses = this.api.getTranslationsArray(request, this.srcCode, this.trgCode, this.maximumHits, this.threshold);
            if (responses != null) {
                for (int i = 0; i < responses.size(); ++i) {
                    queryResults.add(qrBuilder.convertResponses(responses.get(i), originalText.get(i)));
                }
                break;
            }
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException e) {
                throw new OkapiException("Interrupted while trying to contact Microsoft MT");
            }
        }
        if (!queryResults.isEmpty()) {
            return queryResults;
        }
        this.logger.error("Failed to batch translate with Microsoft Translator ({} tries). Skipping query for {}", (Object)5, (Object)request.toString());
        throw new OkapiException("Could not retrieve results from Microsoft MT after 5 attempts.");
    }

    @Override
    public void leverage(ITextUnit tu) {
        this.leverageUsingBatchQuery(tu);
    }

    @Override
    public void batchLeverage(List<ITextUnit> tuList) {
        this.batchLeverageUsingBatchQuery(tuList);
    }

    @Override
    public List<List<QueryResult>> batchQueryText(List<String> plainTexts) {
        return this._batchQuery(plainTexts, plainTexts, new TextQueryResultBuilder(this.params, this.getWeight()));
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        return this._batchQuery(this.util.toCodedHTML(fragments), fragments, new FragmentQueryResultBuilder(this.params, this.getWeight()));
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47().toLowerCase();
        if (code.equals("zh-tw") || code.startsWith("zh-hant") || code.equals("zh-cht") || code.equals("zh-hk")) {
            code = "zh-Hant";
        } else if (code.startsWith("zh")) {
            code = "zh-Hans";
        } else if (code.startsWith("sr-cyrl")) {
            code = "sr-Cyrl";
        } else if (!code.startsWith("pt") && !code.equals("es-419")) {
            if (locale.getLanguage().equals("in")) {
                return "id";
            }
            code = locale.getLanguage();
        }
        return code;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public boolean hasNext() {
        return this.results.hasNext();
    }

    @Override
    public QueryResult next() {
        return this.results.hasNext() ? this.results.next() : null;
    }

    @Override
    public int getMaximumHits() {
        return this.maximumHits;
    }

    @Override
    public void setMaximumHits(int maximumHits) {
        this.maximumHits = maximumHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
        this.threshold = -10;
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        super.setLanguages(sourceLocale, targetLocale);
    }
}

