/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.pensieve;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.FolderInputPart;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String USESERVER = "useServer";
    private static final String HOST = "host";
    private static final String DBDIRECTORY = "dbDirectory";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    public boolean getUseServer() {
        return this.getBoolean(USESERVER);
    }

    public void setUseServer(boolean useServer) {
        this.setBoolean(USESERVER, useServer);
    }

    public String getHost() {
        return this.getString(HOST);
    }

    public void setHost(String host) {
        this.setString(HOST, host);
    }

    public String getDbDirectory() {
        return this.getString(DBDIRECTORY);
    }

    public void setDbDirectory(String dbDirectory) {
        this.setString(DBDIRECTORY, dbDirectory);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDbDirectory("");
        this.setHost("http://localhost:8080/");
        this.setUseServer(false);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USESERVER, "Use a server (instead of a local TM)", null);
        desc.add(HOST, "Server URL", "URL of the server to use (e.g. http://localhost:8080/");
        desc.add(DBDIRECTORY, "TM Directory", "Directory of the TM database");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Pensieve TM Connector Settings", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(USESERVER));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(HOST));
        tip.setMasterPart(cbp, true);
        FolderInputPart fip = desc.addFolderInputPart(paramsDesc.get(DBDIRECTORY), "TM Directory");
        fip.setMasterPart(cbp, false);
        return desc;
    }
}

