/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.html;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;

public class HtmlSkeletonWriter
extends GenericSkeletonWriter {
    private static final String FIRST_PART_OF_HTML_ELEMENT = "<html";
    private static final String RTL_TEXT_DIRECTION_ATTRIBUTE = " dir=\"rtl\"";
    private static final Pattern TEXT_DIRECTION_ATTRIBUTE_PATTERN = Pattern.compile(" dir=\"(?:rtl|ltr)\"");

    @Override
    public String processDocumentPart(DocumentPart resource) {
        if (resource.getSkeleton() instanceof GenericSkeleton) {
            GenericSkeleton skeleton = (GenericSkeleton)resource.getSkeleton();
            StringBuilder firstPartData = skeleton.getFirstPart().getData();
            this.clarifyTextDirection(firstPartData);
        }
        return super.processDocumentPart(resource);
    }

    private void clarifyTextDirection(StringBuilder firstPartData) {
        int indexOfHtmlElement = firstPartData.indexOf(FIRST_PART_OF_HTML_ELEMENT);
        if (-1 == indexOfHtmlElement) {
            return;
        }
        Matcher textDirectionMatcher = TEXT_DIRECTION_ATTRIBUTE_PATTERN.matcher(firstPartData);
        if (textDirectionMatcher.find()) {
            firstPartData.replace(textDirectionMatcher.start(), textDirectionMatcher.end(), this.getTextDirectionAttribute());
        } else {
            firstPartData.insert(indexOfHtmlElement + FIRST_PART_OF_HTML_ELEMENT.length(), this.getTextDirectionAttribute());
        }
    }

    private String getTextDirectionAttribute() {
        return LocaleId.isBidirectional(this.getOutputLoc()) ? RTL_TEXT_DIRECTION_ATTRIBUTE : "";
    }

    @Override
    public String getContent(TextFragment tf, LocaleId locToUse, EncoderContext context) {
        if (!tf.hasCode()) {
            return super.getContent(tf, locToUse, context);
        }
        List<Code> codes = tf.getCodes();
        StringBuilder tmp = new StringBuilder();
        StringBuilder textRun = new StringBuilder();
        String text = tf.getCodedText();
        boolean inlineCdata = false;
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\ue101': {
                    Code code;
                    if (textRun.length() > 0) {
                        tmp.append(this.encodeTextRun(textRun.toString(), inlineCdata, context));
                        textRun.setLength(0);
                    }
                    if (this.isCodeThatDisablesEncoding(code = codes.get(TextFragment.toIndex(text.charAt(++i))))) {
                        inlineCdata = true;
                    }
                    tmp.append(this.expandCodeContent(code, locToUse, context));
                    continue block5;
                }
                case '\ue102': {
                    Code code;
                    if (textRun.length() > 0) {
                        tmp.append(this.encodeTextRun(textRun.toString(), inlineCdata, context));
                        textRun.setLength(0);
                    }
                    if (this.isCodeThatDisablesEncoding(code = codes.get(TextFragment.toIndex(text.charAt(++i))))) {
                        inlineCdata = false;
                    }
                    tmp.append(this.expandCodeContent(code, locToUse, context));
                    continue block5;
                }
                case '\ue103': {
                    if (textRun.length() > 0) {
                        tmp.append(this.encodeTextRun(textRun.toString(), inlineCdata, context));
                        textRun.setLength(0);
                    }
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    tmp.append(this.expandCodeContent(code, locToUse, context));
                    continue block5;
                }
                default: {
                    if (Character.isHighSurrogate(ch)) {
                        int cp = text.codePointAt(i);
                        ++i;
                        textRun.append(Character.toChars(cp));
                        continue block5;
                    }
                    textRun.append(ch);
                }
            }
        }
        if (textRun.length() > 0) {
            tmp.append(this.encodeTextRun(textRun.toString(), inlineCdata, context));
        }
        return tmp.toString();
    }

    private String encodeTextRun(String textRun, boolean inlineCdata, EncoderContext context) {
        if (inlineCdata) {
            return textRun;
        }
        if (this.getEncoderManager() == null) {
            return textRun;
        }
        return this.getEncoderManager().encode(textRun, context);
    }
}

