/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.filters.idml.ParametersStringStyleConfiguration;
import net.sf.okapi.filters.idml.StyleConfiguration;
import net.sf.okapi.filters.idml.StyleConfigurations;

final class ParametersStringStyleConfigurationsInput
implements StyleConfigurations.Input {
    static final String NUMBER = "number";
    private static final int DEFAULT_NUMBER_VALUE = 0;
    private static final String DEFAULT_STRING_VALUE = "";
    private final ParametersString parametersString;
    private final String name;
    private List<StyleConfiguration> styleConfigurations;

    ParametersStringStyleConfigurationsInput(ParametersString parametersString, String name) {
        this.parametersString = parametersString;
        this.name = name;
    }

    @Override
    public Iterator<StyleConfiguration> read() {
        if (null != this.styleConfigurations) {
            return Collections.emptyIterator();
        }
        this.styleConfigurations = new LinkedList<StyleConfiguration>();
        ParametersString ps = new ParametersString(this.parametersString.getGroup(this.name, DEFAULT_STRING_VALUE));
        int numberOfConfigurations = ps.getInteger(NUMBER, 0);
        for (int i = 0; i < numberOfConfigurations; ++i) {
            String configurationString = ps.getGroup(String.valueOf(i), DEFAULT_STRING_VALUE);
            if (DEFAULT_STRING_VALUE.equals(configurationString)) continue;
            this.styleConfigurations.add(new ParametersStringStyleConfiguration(new ParametersString(configurationString)));
        }
        return this.styleConfigurations.iterator();
    }
}

