/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.SpreadItem;
import net.sf.okapi.filters.idml.SpreadItemHolder;
import net.sf.okapi.filters.idml.SpreadItemParser;

class ParsingIdioms {
    static final String UNEXPECTED_STRUCTURE = "Unexpected structure";
    static final QName SELF = Namespaces.getDefaultNamespace().getQName("Self");
    static final QName VISIBLE = Namespaces.getDefaultNamespace().getQName("Visible");
    static final QName ITEM_TRANSFORM = Namespaces.getDefaultNamespace().getQName("ItemTransform");
    private static final QName ITEM_LAYER = Namespaces.getDefaultNamespace().getQName("ItemLayer");
    private static final QName TEXT_FRAME = Namespaces.getDefaultNamespace().getQName("TextFrame");
    private static final QName GRAPHIC_LINE = Namespaces.getDefaultNamespace().getQName("GraphicLine");
    private static final QName RECTANGLE = Namespaces.getDefaultNamespace().getQName("Rectangle");
    private static final QName OVAL = Namespaces.getDefaultNamespace().getQName("Oval");
    private static final QName POLYGON = Namespaces.getDefaultNamespace().getQName("Polygon");
    private static final QName GROUP = Namespaces.getDefaultNamespace().getQName("Group");
    private static final QName MULTI_STATE_OBJECT = Namespaces.getDefaultNamespace().getQName("MultiStateObject");
    private static final QName BUTTON = Namespaces.getDefaultNamespace().getQName("Button");
    private static final QName TEXT_BOX = Namespaces.getDefaultNamespace().getQName("TextBox");

    ParsingIdioms() {
    }

    static boolean getBooleanAttributeValue(StartElement element, QName name, boolean defaultValue) {
        Attribute attribute = element.getAttributeByName(name);
        if (null == attribute) {
            return defaultValue;
        }
        return Boolean.parseBoolean(attribute.getValue());
    }

    static String getItemLayerAttributeValue(StartElement startElement, String activeLayerId) {
        Attribute attribute = startElement.getAttributeByName(ITEM_LAYER);
        if (null == attribute) {
            return activeLayerId;
        }
        return attribute.getValue();
    }

    static List<Attribute> getStartElementAttributes(StartElement startElement) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            attributes.add(iterator.next());
        }
        return attributes;
    }

    static void parseSpreadItems(StartElement startElement, XMLEventReader eventReader, XMLEventFactory eventFactory, SpreadItemHolder spreadItemHolder) throws XMLStreamException {
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                return;
            }
            if (!event.isStartElement()) continue;
            StartElement element = event.asStartElement();
            if (TEXT_FRAME.equals(element.getName())) {
                spreadItemHolder.addSpreadItem(ParsingIdioms.parseTextFrame(element, spreadItemHolder.getActiveLayerId(), eventReader, eventFactory));
                continue;
            }
            if (GRAPHIC_LINE.equals(element.getName())) {
                spreadItemHolder.addSpreadItem(ParsingIdioms.parseGraphicLine(element, spreadItemHolder.getActiveLayerId(), eventReader, eventFactory));
                continue;
            }
            if (RECTANGLE.equals(element.getName())) {
                spreadItemHolder.addSpreadItem(ParsingIdioms.parseRectangle(element, spreadItemHolder.getActiveLayerId(), eventReader, eventFactory));
                continue;
            }
            if (OVAL.equals(element.getName())) {
                spreadItemHolder.addSpreadItem(ParsingIdioms.parseOval(element, spreadItemHolder.getActiveLayerId(), eventReader, eventFactory));
                continue;
            }
            if (POLYGON.equals(element.getName())) {
                spreadItemHolder.addSpreadItem(ParsingIdioms.parsePolygon(element, spreadItemHolder.getActiveLayerId(), eventReader, eventFactory));
                continue;
            }
            if (GROUP.equals(element.getName())) {
                spreadItemHolder.addSpreadItem(ParsingIdioms.parseGroup(element, spreadItemHolder.getActiveLayerId(), eventReader, eventFactory));
                continue;
            }
            if (MULTI_STATE_OBJECT.equals(element.getName())) {
                spreadItemHolder.addSpreadItem(ParsingIdioms.parseMultiStateObject(element, spreadItemHolder.getActiveLayerId(), eventReader, eventFactory));
                continue;
            }
            if (BUTTON.equals(element.getName())) {
                spreadItemHolder.addSpreadItem(ParsingIdioms.parseButton(element, spreadItemHolder.getActiveLayerId(), eventReader, eventFactory));
                continue;
            }
            if (!TEXT_BOX.equals(element.getName())) continue;
            spreadItemHolder.addSpreadItem(ParsingIdioms.parseTextBox(element, spreadItemHolder.getActiveLayerId(), eventReader, eventFactory));
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE);
    }

    private static SpreadItem parseTextFrame(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        SpreadItemParser.TextFrameParser textFrameParser = new SpreadItemParser.TextFrameParser(startElement, activeLayerId, eventReader, eventFactory);
        return textFrameParser.parse(new SpreadItem.TextFrame.TextFrameBuilder());
    }

    private static SpreadItem parseGraphicLine(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        SpreadItemParser.GraphicLineParser graphicLineParser = new SpreadItemParser.GraphicLineParser(startElement, activeLayerId, eventReader, eventFactory);
        return graphicLineParser.parse(new SpreadItem.GraphicLine.GraphicLineBuilder());
    }

    private static SpreadItem parseRectangle(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        SpreadItemParser.RectangleParser rectangleParser = new SpreadItemParser.RectangleParser(startElement, activeLayerId, eventReader, eventFactory);
        return rectangleParser.parse(new SpreadItem.Rectangle.RectangleBuilder());
    }

    private static SpreadItem parseOval(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        SpreadItemParser.OvalParser ovalParser = new SpreadItemParser.OvalParser(startElement, activeLayerId, eventReader, eventFactory);
        return ovalParser.parse(new SpreadItem.Oval.OvalBuilder());
    }

    private static SpreadItem parsePolygon(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        SpreadItemParser.PolygonParser polygonParser = new SpreadItemParser.PolygonParser(startElement, activeLayerId, eventReader, eventFactory);
        return polygonParser.parse(new SpreadItem.Polygon.PolygonBuilder());
    }

    private static SpreadItem parseGroup(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        SpreadItemParser.GroupParser groupParser = new SpreadItemParser.GroupParser(startElement, activeLayerId, eventReader, eventFactory);
        return groupParser.parse(new SpreadItem.Group.GroupBuilder());
    }

    private static SpreadItem parseMultiStateObject(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        SpreadItemParser.MultiStateObjectParser multiStateObjectParser = new SpreadItemParser.MultiStateObjectParser(startElement, activeLayerId, eventReader, eventFactory);
        return multiStateObjectParser.parse(new SpreadItem.MultiStateObject.MultiStateObjectBuilder());
    }

    private static SpreadItem parseButton(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        SpreadItemParser.ButtonParser buttonParser = new SpreadItemParser.ButtonParser(startElement, activeLayerId, eventReader, eventFactory);
        return buttonParser.parse(new SpreadItem.Button.ButtonBuilder());
    }

    private static SpreadItem parseTextBox(StartElement startElement, String activeLayerId, XMLEventReader eventReader, XMLEventFactory eventFactory) throws XMLStreamException {
        SpreadItemParser.TextBoxParser textBoxParser = new SpreadItemParser.TextBoxParser(startElement, activeLayerId, eventReader, eventFactory);
        return textBoxParser.parse(new SpreadItem.TextBox.TextBoxBuilder());
    }

    static enum StyledStoryChildElement {
        PARAGRAPH_STYLE_RANGE("ParagraphStyleRange"),
        CHARACTER_STYLE_RANGE("CharacterStyleRange"),
        FOOTNOTE("Footnote"),
        ENDNOTE("Endnote"),
        ENDNOTE_RANGE("EndnoteRange"),
        GAIJI_OWNED_ITEM_OBJECT("GaijiOwnedItemObject"),
        NOTE("Note"),
        TABLE("Table"),
        TEXT_VARIABLE_INSTANCE("TextVariableInstance"),
        HYPERLINK_TEXT_DESTINATION("HyperlinkTextDestination"),
        CHANGE("Change"),
        HIDDEN_TEXT("HiddenText"),
        XML_ELEMENT("XMLElement"),
        XML_ATTRIBUTE("XMLAttribute"),
        XML_COMMENT("XMLComment"),
        XML_INSTRUCTION("XMLInstruction"),
        DTD("DTD"),
        OVAL("Oval"),
        RECTANGLE("Rectangle"),
        GRAPHIC_LINE("GraphicLine"),
        POLYGON("Polygon"),
        GROUP("Group"),
        TEXT_FRAME("TextFrame"),
        BUTTON("Button"),
        FORM_FIELD("FormField"),
        MULTI_STATE_OBJECT("MultiStateObject"),
        EPS_TEXT("EPSText"),
        HYPERLINK_TEXT_SOURCE("HyperlinkTextSource"),
        PAGE_REFERENCE("PageReference"),
        PARAGRAPH_DESTINATION("ParagraphDestination"),
        CROSS_REFERENCE_SOURCE("CrossReferenceSource"),
        CONTENT("Content"),
        BREAK("Br"),
        UNSUPPORTED("");

        private final QName name;

        private StyledStoryChildElement(String name) {
            this.name = Namespaces.getDefaultNamespace().getQName(name);
        }

        QName getName() {
            return this.name;
        }

        static StyledStoryChildElement fromName(QName name) {
            if (null == name) {
                return UNSUPPORTED;
            }
            for (StyledStoryChildElement styledStoryChildElement : StyledStoryChildElement.values()) {
                if (!styledStoryChildElement.getName().equals(name)) continue;
                return styledStoryChildElement;
            }
            return UNSUPPORTED;
        }
    }
}

