/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

class Preferences {
    private final XMLPreference xmlPreference;
    private final StoryPreference storyPreference;

    Preferences(XMLPreference xmlPreference, StoryPreference storyPreference) {
        this.xmlPreference = xmlPreference;
        this.storyPreference = storyPreference;
    }

    XMLPreference getXmlPreference() {
        return this.xmlPreference;
    }

    StoryPreference getStoryPreference() {
        return this.storyPreference;
    }

    static class XMLPreference {
        private final String defaultStoryTagName;
        private final String defaultTableTagName;
        private final String defaultCellTagName;

        XMLPreference(String defaultStoryTagName, String defaultTableTagName, String defaultCellTagName) {
            this.defaultStoryTagName = defaultStoryTagName;
            this.defaultTableTagName = defaultTableTagName;
            this.defaultCellTagName = defaultCellTagName;
        }

        String getDefaultStoryTagName() {
            return this.defaultStoryTagName;
        }

        String getDefaultTableTagName() {
            return this.defaultTableTagName;
        }

        String getDefaultCellTagName() {
            return this.defaultCellTagName;
        }
    }

    static class StoryPreference {
        private final String storyDirection;

        StoryPreference(String storyDirection) {
            this.storyDirection = storyDirection;
        }

        String getStoryDirection() {
            return this.storyDirection;
        }
    }

    static class PreferencesBuilder {
        private XMLPreference xmlPreference;
        private StoryPreference storyPreference;

        PreferencesBuilder() {
        }

        PreferencesBuilder setXmlPreference(XMLPreference xmlPreference) {
            this.xmlPreference = xmlPreference;
            return this;
        }

        PreferencesBuilder setStoryPreference(StoryPreference storyPreference) {
            this.storyPreference = storyPreference;
            return this;
        }

        Preferences build() {
            return new Preferences(this.xmlPreference, this.storyPreference);
        }
    }
}

