/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.PropertyParser;

class PropertiesParser {
    private final StartElement startElement;
    private final XMLEventReader eventReader;
    private final XMLEventFactory eventFactory;

    PropertiesParser(StartElement startElement, XMLEventReader eventReader, XMLEventFactory eventFactory) {
        this.startElement = startElement;
        this.eventReader = eventReader;
        this.eventFactory = eventFactory;
    }

    Properties parse() throws XMLStreamException {
        Properties.Builder propertiesBuilder = new Properties.Builder(new Properties.Comparator());
        propertiesBuilder.setStartElement(this.startElement);
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextTag();
            if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                propertiesBuilder.setEndElement(event.asEndElement());
                return propertiesBuilder.build();
            }
            if (!event.isStartElement()) {
                throw new IllegalStateException("Unexpected structure");
            }
            propertiesBuilder.addProperty(new PropertyParser(event.asStartElement(), this.eventReader, this.eventFactory).parse());
        }
        throw new IllegalStateException("Unexpected structure");
    }
}

