/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocalePair;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.MarkupSkeleton;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.ReferenceableEvent;
import net.sf.okapi.filters.idml.SpecialCharacter;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleRanges;
import net.sf.okapi.filters.idml.StyledTextReferenceSkeleton;
import net.sf.okapi.filters.idml.StyledTextSkeleton;

class ReferenceableEventsMerger {
    private static final String UNEXPECTED_CODE = "Unexpected code";
    private static final QName CONTENT_SPACE_ATTRIBUTE_NAME = Namespaces.getXmlNamespace().getQName("space");
    private static final String CONTENT_SPACE_ATTRIBUTE_VALUE = "preserve";
    private final XMLEventFactory eventFactory;
    private final LocalePair localePair;
    private final FontMappings fontMappings;
    private List<StoryChildElement> storyChildElements;
    private StyleRanges baseStyleRanges;
    private Map<Integer, Object> codeMap;
    private Deque<List<StoryChildElement>> savedStoryChildElements;
    private Deque<StyleRanges> savedBaseStyleRanges;
    private StoryChildElement savedBreak;
    private Deque<StyleRanges> currentStyleRanges;
    private StringBuilder contentTextBuilder;
    private List<XMLEvent> contentEvents;

    ReferenceableEventsMerger(XMLEventFactory eventFactory, LocalePair localePair, FontMappings fontMappings) {
        this.eventFactory = eventFactory;
        this.localePair = localePair;
        this.fontMappings = fontMappings;
    }

    void merge(ReferenceableEvent referenceableEvent) {
        for (ReferenceableEvent referentEvent : referenceableEvent.getReferentEvents()) {
            new ReferenceableEventsMerger(this.eventFactory, this.localePair, this.fontMappings).merge(referentEvent);
        }
        if (referenceableEvent.getEvent().isStartGroup()) {
            this.mergeStartGroup(referenceableEvent);
            return;
        }
        if (referenceableEvent.getEvent().isDocumentPart()) {
            return;
        }
        this.mergeTextUnit(referenceableEvent);
    }

    private void mergeStartGroup(ReferenceableEvent referenceableEvent) {
        StyledTextReferenceSkeleton styledTextReferenceSkeleton = (StyledTextReferenceSkeleton)referenceableEvent.getEvent().getStartGroup().getSkeleton();
        StoryChildElement.StyledTextReferenceElement styledTextReferenceElement = styledTextReferenceSkeleton.getStyledTextReferenceElement();
        if (styledTextReferenceElement instanceof StoryChildElement.StyledTextReferenceElement.Table) {
            return;
        }
        this.storyChildElements = styledTextReferenceElement.getStoryChildElements();
        this.storyChildElements.clear();
        for (ReferenceableEvent referentEvent : referenceableEvent.getReferentEvents()) {
            if (referentEvent.getEvent().isStartGroup()) {
                StoryChildElement.StyledTextReferenceElement nestedStyledTextReferenceElement = ((StyledTextReferenceSkeleton)referenceableEvent.getEvent().getStartGroup().getSkeleton()).getStyledTextReferenceElement();
                if (!(nestedStyledTextReferenceElement instanceof StoryChildElement.StyledTextReferenceElement.Table)) continue;
                this.storyChildElements.add(nestedStyledTextReferenceElement);
            }
            if (referentEvent.getEvent().isDocumentPart()) {
                ISkeleton skeleton = referentEvent.getEvent().getDocumentPart().getSkeleton();
                if (skeleton instanceof MarkupSkeleton) {
                    this.addStoryChildElementsFromMarkupSkeleton((MarkupSkeleton)skeleton);
                    continue;
                }
                if (skeleton instanceof StyledTextSkeleton) {
                    this.addStoryChildElementsFromStyledTextSkeleton((StyledTextSkeleton)skeleton);
                    continue;
                }
                throw new IllegalStateException("Unexpected structure");
            }
            this.addStoryChildElementsFromStyledTextSkeleton((StyledTextSkeleton)referentEvent.getEvent().getTextUnit().getSkeleton());
        }
    }

    private void addStoryChildElementsFromMarkupSkeleton(MarkupSkeleton markupSkeleton) {
        for (MarkupRange markupRange : markupSkeleton.getMarkup()) {
            if (!(markupRange instanceof StoryChildElement)) {
                throw new IllegalStateException("Unexpected structure");
            }
            this.storyChildElements.add((StoryChildElement)markupRange);
        }
    }

    private void addStoryChildElementsFromStyledTextSkeleton(StyledTextSkeleton styledTextSkeleton) {
        this.storyChildElements.addAll(styledTextSkeleton.getStoryChildElements());
    }

    private void mergeTextUnit(ReferenceableEvent referenceableEvent) {
        ITextUnit textUnit = referenceableEvent.getEvent().getTextUnit();
        StyledTextSkeleton styledTextSkeleton = (StyledTextSkeleton)textUnit.getSkeleton();
        this.storyChildElements = styledTextSkeleton.getStoryChildElements();
        this.baseStyleRanges = styledTextSkeleton.baseStyleRanges();
        this.codeMap = styledTextSkeleton.getCodeMap();
        this.savedStoryChildElements = new ArrayDeque<List<StoryChildElement>>();
        this.savedBaseStyleRanges = new ArrayDeque<StyleRanges>();
        this.savedBreak = this.breakIn(this.storyChildElements);
        this.storyChildElements.clear();
        this.currentStyleRanges = new ArrayDeque<StyleRanges>();
        this.contentTextBuilder = new StringBuilder();
        this.contentEvents = new ArrayList<XMLEvent>();
        this.merge(null == textUnit.getTarget(this.localePair.target()) ? textUnit.getSource() : textUnit.getTarget(this.localePair.target()));
    }

    private StoryChildElement breakIn(List<StoryChildElement> textUnitElements) {
        for (StoryChildElement storyChildElement : textUnitElements) {
            if (!(storyChildElement instanceof StoryChildElement.StyledTextElement.Break)) continue;
            return storyChildElement;
        }
        return null;
    }

    private void merge(TextContainer textContainer) {
        for (TextPart textPart : textContainer.getParts()) {
            this.merge(textPart);
        }
        this.addContent();
        this.addBreak();
    }

    private void merge(TextPart textPart) {
        TextFragment textFragment = textPart.getContent();
        String codedText = textFragment.getCodedText();
        List<Code> codes = textFragment.getCodes();
        for (int i = 0; i < codedText.length(); ++i) {
            char c = codedText.charAt(i);
            if (!TextFragment.isMarker(c)) {
                this.addChar(c);
                continue;
            }
            int codeIndex = TextFragment.toIndex(codedText.charAt(++i));
            this.addCode(codes.get(codeIndex));
        }
    }

    private void addChar(char c) {
        this.contentTextBuilder.append(c);
    }

    private void addCode(Code code) {
        Object codeObject = this.codeMap.get(code.getId());
        switch (code.getTagType()) {
            case OPENING: {
                if (codeObject instanceof List) {
                    ((List)codeObject).forEach(o -> this.add(o));
                    break;
                }
                this.addContent();
                if (codeObject instanceof StyleRanges) {
                    this.currentStyleRanges.push((StyleRanges)codeObject);
                    break;
                }
                if (codeObject instanceof StoryChildElement.StyledTextReferenceElement) {
                    if (codeObject instanceof StoryChildElement.StyledTextReferenceElement.HyperlinkTextSource) {
                        StoryChildElement.StyledTextReferenceElement.HyperlinkTextSource hts = (StoryChildElement.StyledTextReferenceElement.HyperlinkTextSource)codeObject;
                        this.savedBaseStyleRanges.push(this.baseStyleRanges);
                        this.baseStyleRanges = hts.childContentMinimalStyleRanges();
                        this.currentStyleRanges.push(this.baseStyleRanges);
                    } else {
                        this.currentStyleRanges.push(((StoryChildElement.StyledTextReferenceElement)codeObject).styleRanges());
                    }
                    this.storyChildElements.add((StoryChildElement.StyledTextReferenceElement)codeObject);
                    this.savedStoryChildElements.push(this.storyChildElements);
                    this.storyChildElements = ((StoryChildElement.StyledTextReferenceElement)codeObject).getStoryChildElements();
                    this.storyChildElements.clear();
                    break;
                }
                throw new IllegalStateException(UNEXPECTED_CODE + String.valueOf(codeObject));
            }
            case PLACEHOLDER: {
                if (codeObject instanceof List) {
                    ((List)codeObject).forEach(o -> this.add(o));
                    break;
                }
                this.add(codeObject);
                break;
            }
            case CLOSING: {
                if (codeObject instanceof List) {
                    ((List)codeObject).forEach(o -> this.add(o));
                    break;
                }
                this.addContent();
                if (codeObject instanceof StyleRanges) {
                    this.currentStyleRanges.pop();
                    break;
                }
                if (codeObject instanceof StoryChildElement.StyledTextReferenceElement) {
                    if (codeObject instanceof StoryChildElement.StyledTextReferenceElement.HyperlinkTextSource) {
                        this.baseStyleRanges = this.savedBaseStyleRanges.pop();
                    }
                    this.currentStyleRanges.pop();
                    this.storyChildElements = this.savedStoryChildElements.pop();
                    break;
                }
                throw new IllegalStateException(UNEXPECTED_CODE + String.valueOf(codeObject));
            }
        }
    }

    private void add(Object codeObject) {
        if (codeObject instanceof StyleRanges) {
            this.addContent();
            StyleRanges srs = (StyleRanges)codeObject;
            if (srs.equals(this.currentStyleRanges.peek())) {
                this.currentStyleRanges.pop();
            } else {
                this.currentStyleRanges.push(srs);
            }
        } else if (codeObject instanceof String) {
            this.contentTextBuilder.append(codeObject);
        } else if (codeObject instanceof SpecialCharacter) {
            this.addSpecialCharacter((SpecialCharacter)codeObject);
        } else if (codeObject instanceof StoryChildElement) {
            this.addStoryChildElement((StoryChildElement)codeObject);
        } else {
            throw new IllegalStateException(UNEXPECTED_CODE + String.valueOf(codeObject));
        }
    }

    private void addSpecialCharacter(SpecialCharacter specialCharacter) {
        if (!(specialCharacter instanceof SpecialCharacter.Instruction)) {
            this.contentTextBuilder.append(specialCharacter.event().asCharacters().getData());
            return;
        }
        if (0 < this.contentTextBuilder.length()) {
            this.contentEvents.add(this.eventFactory.createCharacters(this.contentTextBuilder.toString()));
            this.contentTextBuilder = new StringBuilder();
        }
        this.contentEvents.addAll(specialCharacter.getEvents());
    }

    private void addStoryChildElement(StoryChildElement storyChildElement) {
        this.addContent();
        this.storyChildElements.add(storyChildElement);
    }

    private void addContent() {
        if (this.contentEvents.isEmpty() && 0 == this.contentTextBuilder.length()) {
            return;
        }
        ArrayList<Attribute> contentAttributes = new ArrayList<Attribute>();
        contentAttributes.add(this.eventFactory.createAttribute(CONTENT_SPACE_ATTRIBUTE_NAME, CONTENT_SPACE_ATTRIBUTE_VALUE));
        StoryChildElement.StyledTextElement.Content.ContentBuilder contentBuilder = new StoryChildElement.StyledTextElement.Content.ContentBuilder();
        contentBuilder.setStartElement(this.eventFactory.createStartElement(ParsingIdioms.StyledStoryChildElement.CONTENT.getName(), contentAttributes.iterator(), null));
        if (!this.contentEvents.isEmpty()) {
            for (XMLEvent event : this.contentEvents) {
                contentBuilder.addInnerEvent(event);
            }
            this.contentEvents = new ArrayList<XMLEvent>();
        }
        if (0 < this.contentTextBuilder.length()) {
            contentBuilder.addInnerEvent(this.eventFactory.createCharacters(this.contentTextBuilder.toString()));
            this.contentTextBuilder = new StringBuilder();
        }
        contentBuilder.setEndElement(this.eventFactory.createEndElement(ParsingIdioms.StyledStoryChildElement.CONTENT.getName(), null));
        contentBuilder.setStyleRanges(this.styleRanges());
        this.storyChildElements.add(contentBuilder.build());
    }

    private void addBreak() {
        if (null == this.savedBreak) {
            return;
        }
        this.storyChildElements.add(this.savedBreak);
    }

    private StyleRanges styleRanges() {
        StyleRanges styleRanges = this.currentStyleRanges.isEmpty() ? this.baseStyleRanges : this.currentStyleRanges.peek();
        styleRanges.apply(this.fontMappings.applicableTo(this.localePair));
        return styleRanges;
    }
}

