/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupSkeleton;
import net.sf.okapi.filters.idml.ReferenceableEvent;
import net.sf.okapi.filters.idml.ReferenceableEventsMerger;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StoryChildElementsWriter;
import net.sf.okapi.filters.idml.StyleRange;
import net.sf.okapi.filters.idml.StyleRanges;
import net.sf.okapi.filters.idml.StyledTextSkeleton;

class ReferenceableEventsWriter {
    private final ReferenceableEventsMerger referenceableEventMerger;
    private StoryChildElementsWriter storyChildElementsWriter;
    private List<XMLEvent> events;
    private boolean styledReferenceableEventEmpty;

    ReferenceableEventsWriter(ReferenceableEventsMerger referenceableEventMerger) {
        this.referenceableEventMerger = referenceableEventMerger;
    }

    List<XMLEvent> write(List<ReferenceableEvent> referenceableEvents) {
        this.events = new ArrayList<XMLEvent>();
        this.styledReferenceableEventEmpty = false;
        this.storyChildElementsWriter = new StoryChildElementsWriter(StyleRange.PARAGRAPH_STYLE_RANGE, StyleRange.CHARACTER_STYLE_RANGE);
        ReferenceableEvent lastStyledReferenceableEvent = this.lastStyledReferenceableEvent(referenceableEvents);
        for (ReferenceableEvent referenceableEvent : referenceableEvents) {
            this.writeReferenceableEvent(referenceableEvent);
            if (referenceableEvent != lastStyledReferenceableEvent || this.styledReferenceableEventEmpty) continue;
            StyleRanges styleRanges = this.styleRangesOf(lastStyledReferenceableEvent);
            this.events.addAll(styleRanges.characterStyleRange().asStyleRangeEnd());
            this.events.addAll(styleRanges.paragraphStyleRange().asStyleRangeEnd());
        }
        return this.events;
    }

    private ReferenceableEvent lastStyledReferenceableEvent(List<ReferenceableEvent> referenceableEvents) {
        ListIterator<ReferenceableEvent> listIterator = referenceableEvents.listIterator(referenceableEvents.size());
        while (listIterator.hasPrevious()) {
            ReferenceableEvent referenceableEvent = listIterator.previous();
            if (!this.isStyledReferenceableEvent(referenceableEvent)) continue;
            return referenceableEvent;
        }
        return null;
    }

    private boolean isStyledReferenceableEvent(ReferenceableEvent referenceableEvent) {
        switch (referenceableEvent.getEvent().getEventType()) {
            case TEXT_UNIT: {
                return true;
            }
            case DOCUMENT_PART: {
                return referenceableEvent.getEvent().getDocumentPart().getSkeleton() instanceof StyledTextSkeleton;
            }
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private void writeReferenceableEvent(ReferenceableEvent referenceableEvent) {
        switch (referenceableEvent.getEvent().getEventType()) {
            case TEXT_UNIT: {
                this.writeTextUnitReferenceableEvent(referenceableEvent);
                break;
            }
            case DOCUMENT_PART: {
                this.writeDocumentPartReferenceableEvent(referenceableEvent);
            }
        }
    }

    private void writeTextUnitReferenceableEvent(ReferenceableEvent referenceableEvent) {
        this.referenceableEventMerger.merge(referenceableEvent);
        StyledTextSkeleton skeleton = (StyledTextSkeleton)referenceableEvent.getEvent().getTextUnit().getSkeleton();
        List<XMLEvent> currentEvents = this.storyChildElementsWriter.write(skeleton.getStoryChildElements());
        if (currentEvents.isEmpty()) {
            this.styledReferenceableEventEmpty = true;
        }
        this.events.addAll(currentEvents);
    }

    private void writeDocumentPartReferenceableEvent(ReferenceableEvent referenceableEvent) {
        ISkeleton skeleton = referenceableEvent.getEvent().getDocumentPart().getSkeleton();
        if (skeleton instanceof MarkupSkeleton) {
            Markup markup = ((MarkupSkeleton)skeleton).getMarkup();
            this.events.addAll(markup.getEvents());
            return;
        }
        if (skeleton instanceof StyledTextSkeleton) {
            List<XMLEvent> currentEvents = this.storyChildElementsWriter.write(((StyledTextSkeleton)skeleton).getStoryChildElements());
            if (currentEvents.isEmpty()) {
                this.styledReferenceableEventEmpty = true;
            }
            this.events.addAll(currentEvents);
            return;
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private StyleRanges styleRangesOf(ReferenceableEvent referenceableEvent) {
        StyleRanges styleRanges = EventType.TEXT_UNIT.equals((Object)referenceableEvent.getEvent().getEventType()) ? this.lastStyledTextElementIn((StyledTextSkeleton)referenceableEvent.getEvent().getTextUnit().getSkeleton()).styleRanges() : this.lastStyledTextElementIn((StyledTextSkeleton)referenceableEvent.getEvent().getDocumentPart().getSkeleton()).styleRanges();
        return styleRanges;
    }

    private StoryChildElement.StyledTextElement lastStyledTextElementIn(StyledTextSkeleton skeleton) {
        ListIterator<StoryChildElement> iterator = skeleton.getStoryChildElements().listIterator(skeleton.getStoryChildElements().size());
        StoryChildElement.StyledTextElement ste = null;
        while (iterator.hasPrevious()) {
            StoryChildElement sce = iterator.previous();
            if (!(sce instanceof StoryChildElement.StyledTextElement)) continue;
            ste = (StoryChildElement.StyledTextElement)sce;
            break;
        }
        if (null == ste) {
            throw new IllegalStateException("A styled text element is not available in ".concat(skeleton.getStoryChildElements().toString()));
        }
        return ste;
    }
}

