/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.MarkupRange;

interface SpecialCharacter
extends MarkupRange {
    public XMLEvent event();

    public Type type();

    public static enum Type {
        ALIGNMENT("0"),
        END_NESTED_STYLE("3"),
        FOOTNOTE_MARKER("4"),
        INDENT_HERE_TAB("7"),
        RIGHT_INDENT_TAB("8"),
        AUTO_PAGE_NUMBER("18"),
        SECTION_MARKER("19"),
        FIXED_WIDTH_NON_BREAKING_SPACE("\u202f"),
        HAIR_SPACE("\u200a"),
        THIN_SPACE("\u2009"),
        PUNCTUATION_SPACE("\u2008"),
        FIGURE_SPACE("\u2007"),
        SIXTH_SPACE("\u2006"),
        QUARTER_SPACE("\u2005"),
        THIRD_SPACE("\u2004"),
        FLUSH_SPACE("\u2001"),
        FORCED_LINE_BREAK("\u2028"),
        DISCRETIONARY_LINE_BRAKE("\u200b"),
        ZERO_WIDTH_NON_JOINER("\u200c"),
        DISCRETIONARY_HYPHEN("\u00ad"),
        NON_BREAKING_HYPHEN("\u2011"),
        ZERO_WIDTH_NO_BREAK_SPACE("\ufeff"),
        GENERAL("");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        static Type fromDefault(Default defaultSpecialCharacter) {
            return Type.fromDefaultString(defaultSpecialCharacter.event().asCharacters().getData());
        }

        static Type fromDefaultString(String string) {
            for (Type type : EnumSet.range(FIXED_WIDTH_NON_BREAKING_SPACE, ZERO_WIDTH_NO_BREAK_SPACE)) {
                if (!type.toString().equals(string)) continue;
                return type;
            }
            return GENERAL;
        }

        static Type fromInstruction(Instruction instruction) {
            for (Type type : EnumSet.range(ALIGNMENT, SECTION_MARKER)) {
                if (!type.toString().equals(((ProcessingInstruction)instruction.event()).getData())) continue;
                return type;
            }
            return GENERAL;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Instruction
    implements SpecialCharacter {
        private final Default defaultSpecialCharacter;

        Instruction(XMLEvent event) {
            this(new Default(event));
        }

        Instruction(Default defaultSpecialCharacter) {
            this.defaultSpecialCharacter = defaultSpecialCharacter;
        }

        @Override
        public XMLEvent event() {
            return this.defaultSpecialCharacter.event();
        }

        @Override
        public Type type() {
            return Type.fromInstruction(this);
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.defaultSpecialCharacter.getEvents();
        }
    }

    public static class Default
    implements SpecialCharacter {
        private final MarkupRange.Default defaultRange;

        Default(XMLEvent event) {
            this(Collections.singletonList(event));
        }

        Default(List<XMLEvent> events) {
            this(new MarkupRange.Default(events));
        }

        Default(MarkupRange.Default range) {
            this.defaultRange = range;
        }

        @Override
        public XMLEvent event() {
            return this.getEvents().get(0);
        }

        @Override
        public Type type() {
            return Type.fromDefault(this);
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.defaultRange.getEvents();
        }
    }
}

