/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.Property;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleIgnorances;
import net.sf.okapi.filters.idml.StyleRange;
import net.sf.okapi.filters.idml.StyleRanges;

final class StoryChildElementsMerger {
    private static final String UNEXPECTED_ELEMENT_TYPE = "Unexpected element type: ";
    private static final int MIN_NUMBER_OF_CHILD_ELEMENTS_TO_MERGE = 2;
    private static final int CURRENT_ELEMENT_INDEX = 0;
    private static final int NEXT_ELEMENT_INDEX = 1;
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;

    StoryChildElementsMerger(Parameters parameters, XMLEventFactory eventFactory) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
    }

    List<StoryChildElement> merge(List<StoryChildElement> storyChildElements) {
        if (!this.neededToBeMerged(storyChildElements)) {
            return storyChildElements;
        }
        ArrayList<StoryChildElement> mergedStoryChildElements = new ArrayList<StoryChildElement>(storyChildElements.size());
        Iterator<StoryChildElement> elementIterator = storyChildElements.iterator();
        StoryChildElement currentElement = elementIterator.next();
        do {
            boolean elementsStyleRangesCanBeMerged;
            StoryChildElement nextElement;
            if (this.canElementsBeMerged(currentElement, nextElement = elementIterator.next(), elementsStyleRangesCanBeMerged = this.canElementsStyleRangesBeMerged(currentElement, nextElement))) {
                currentElement = this.mergeElements(currentElement, nextElement);
                continue;
            }
            if (elementsStyleRangesCanBeMerged) {
                List<StoryChildElement> elements = StoryChildElementsMerger.mergeElementsStyleRanges(currentElement, nextElement);
                mergedStoryChildElements.add(elements.get(0));
                currentElement = elements.get(1);
                continue;
            }
            mergedStoryChildElements.add(currentElement);
            currentElement = nextElement;
        } while (elementIterator.hasNext());
        mergedStoryChildElements.add(currentElement);
        return mergedStoryChildElements;
    }

    private boolean neededToBeMerged(List<StoryChildElement> storyChildElements) {
        return 2 <= storyChildElements.size();
    }

    private boolean canElementsBeMerged(StoryChildElement currentElement, StoryChildElement nextElement, boolean elementsStyleRangesCanBeMerged) {
        return this.isContent(currentElement) && this.isContent(nextElement) && elementsStyleRangesCanBeMerged;
    }

    private boolean isContent(StoryChildElement element) {
        return element instanceof StoryChildElement.StyledTextElement.Content;
    }

    private boolean canElementsStyleRangesBeMerged(StoryChildElement currentElement, StoryChildElement nextElement) {
        if (!this.hasElementStyleRanges(currentElement) || !this.hasElementStyleRanges(nextElement)) {
            return false;
        }
        return this.canStyleRangesBeMerged(this.elementStyleRanges(currentElement).combinedStyleRange(), this.elementStyleRanges(nextElement).combinedStyleRange());
    }

    private boolean hasElementStyleRanges(StoryChildElement element) {
        return element instanceof StoryChildElement.StyledTextElement && null != ((StoryChildElement.StyledTextElement)element).styleRanges();
    }

    private StyleRanges elementStyleRanges(StoryChildElement element) {
        if (!this.hasElementStyleRanges(element)) {
            throw new IllegalArgumentException(UNEXPECTED_ELEMENT_TYPE + element.getClass().getTypeName());
        }
        return ((StoryChildElement.StyledTextElement)element).styleRanges();
    }

    private boolean canStyleRangesBeMerged(StyleRange currentStyleRange, StyleRange nextStyleRange) {
        return this.canAttributesBeMerged(currentStyleRange.attributes(), nextStyleRange.attributes()) && this.canPropertiesBeMerged(currentStyleRange.properties(), nextStyleRange.properties());
    }

    private boolean canAttributesBeMerged(List<Attribute> currentAttributes, List<Attribute> nextAttributes) {
        Set<Attribute> nextAttributesWithoutIgnorances;
        Map<QName, Attribute> currentAttributeIgnorancesByName = this.attributeIgnorancesByName(currentAttributes);
        Map<QName, Attribute> nextAttributeIgnorancesByName = this.attributeIgnorancesByName(nextAttributes);
        Set<Attribute> currentAttributesWithoutIgnorances = StoryChildElementsMerger.attributesWithoutIgnorances(currentAttributes, currentAttributeIgnorancesByName);
        return StoryChildElementsMerger.canAttributesWithoutIgnorancesBeMerged(currentAttributesWithoutIgnorances, nextAttributesWithoutIgnorances = StoryChildElementsMerger.attributesWithoutIgnorances(nextAttributes, nextAttributeIgnorancesByName)) && this.canAttributesWithIgnorancesBeMerged(currentAttributeIgnorancesByName, nextAttributeIgnorancesByName);
    }

    private Map<QName, Attribute> attributeIgnorancesByName(List<Attribute> attributes) {
        return attributes.stream().filter(attribute -> this.parameters.styleIgnorances().isAttributeNamePresent(attribute.getName())).collect(Collectors.toMap(Attribute::getName, Function.identity()));
    }

    private static Set<Attribute> attributesWithoutIgnorances(List<Attribute> attributes, Map<QName, Attribute> attributeIgnorancesByName) {
        return attributes.stream().filter(attribute -> !attributeIgnorancesByName.containsKey(attribute.getName())).collect(Collectors.toSet());
    }

    private static boolean canAttributesWithoutIgnorancesBeMerged(Set<Attribute> currentAttributesWithoutIgnorances, Set<Attribute> nextAttributesWithoutIgnorances) {
        return currentAttributesWithoutIgnorances.equals(nextAttributesWithoutIgnorances);
    }

    private boolean canAttributesWithIgnorancesBeMerged(Map<QName, Attribute> currentAttributeIgnorancesByName, Map<QName, Attribute> nextAttributeIgnorancesByName) {
        Set<QName> commonAttributeNameIgnorances = currentAttributeIgnorancesByName.keySet().stream().filter(nextAttributeIgnorancesByName::containsKey).collect(Collectors.toSet());
        return this.canCommonAttributeNameIgnorancesBeMerged(currentAttributeIgnorancesByName, nextAttributeIgnorancesByName, commonAttributeNameIgnorances) && this.canDistinctAttributeNameIgnorancesBeMerged(currentAttributeIgnorancesByName, commonAttributeNameIgnorances) && this.canDistinctAttributeNameIgnorancesBeMerged(nextAttributeIgnorancesByName, commonAttributeNameIgnorances);
    }

    private boolean canCommonAttributeNameIgnorancesBeMerged(Map<QName, Attribute> currentAttributeIgnorancesByName, Map<QName, Attribute> nextAttributeIgnorancesByName, Set<QName> commonAttributeNameIgnorances) {
        for (QName name : commonAttributeNameIgnorances) {
            if (this.canValuesBeIgnored(name, currentAttributeIgnorancesByName.get(name).getValue(), nextAttributeIgnorancesByName.get(name).getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean canDistinctAttributeNameIgnorancesBeMerged(Map<QName, Attribute> attributeIgnorancesByName, Set<QName> commonAttributeNameIgnorances) {
        Set attributeNameIgnorances = attributeIgnorancesByName.keySet().stream().filter(name -> !commonAttributeNameIgnorances.contains(name)).collect(Collectors.toSet());
        for (QName name2 : attributeNameIgnorances) {
            if (this.canValuesBeIgnored(name2, attributeIgnorancesByName.get(name2).getValue(), attributeIgnorancesByName.get(name2).getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean canValuesBeIgnored(QName name, String currentValue, String nextValue) {
        StyleIgnorances.Thresholds thresholds = this.parameters.styleIgnorances().thresholds(name);
        switch (thresholds.type()) {
            case INTEGER: {
                return this.canIntegerValuesBeIgnored(Integer.valueOf(currentValue), Integer.valueOf(nextValue), thresholds);
            }
            case DOUBLE: {
                return this.canDoubleValuesBeIgnored(Double.valueOf(currentValue), Double.valueOf(nextValue), thresholds);
            }
            case STRING: {
                return this.canStringValuesBeIgnored(thresholds);
            }
        }
        return false;
    }

    private boolean canIntegerValuesBeIgnored(int currentValue, int nextValue, StyleIgnorances.Thresholds thresholds) {
        if (!thresholds.min().isEmpty() && thresholds.max().isEmpty()) {
            int minThreshold = Integer.valueOf(thresholds.min());
            return minThreshold <= currentValue && minThreshold <= nextValue;
        }
        if (thresholds.min().isEmpty() && !thresholds.max().isEmpty()) {
            int maxThreshold = Integer.valueOf(thresholds.max());
            return currentValue <= maxThreshold && nextValue <= maxThreshold;
        }
        if (!thresholds.min().isEmpty() && !thresholds.max().isEmpty()) {
            int minThreshold = Integer.valueOf(thresholds.min());
            int maxThreshold = Integer.valueOf(thresholds.max());
            return minThreshold <= currentValue && minThreshold <= nextValue && currentValue <= maxThreshold && nextValue <= maxThreshold;
        }
        return true;
    }

    private boolean canDoubleValuesBeIgnored(double currentValue, double nextValue, StyleIgnorances.Thresholds thresholds) {
        if (!thresholds.min().isEmpty() && thresholds.max().isEmpty()) {
            double minThreshold = Double.valueOf(thresholds.min());
            return minThreshold <= currentValue && minThreshold <= nextValue;
        }
        if (thresholds.min().isEmpty() && !thresholds.max().isEmpty()) {
            double maxThreshold = Double.valueOf(thresholds.max());
            return currentValue <= maxThreshold && nextValue <= maxThreshold;
        }
        if (!thresholds.min().isEmpty() && !thresholds.max().isEmpty()) {
            double minThreshold = Double.valueOf(thresholds.min());
            double maxThreshold = Double.valueOf(thresholds.max());
            return minThreshold <= currentValue && minThreshold <= nextValue && currentValue <= maxThreshold && nextValue <= maxThreshold;
        }
        return true;
    }

    private boolean canStringValuesBeIgnored(StyleIgnorances.Thresholds thresholds) {
        return thresholds.areEmpty();
    }

    private boolean canPropertiesBeMerged(Properties currentProperties, Properties nextProperties) {
        Set<Property> nextAttributesWithoutIgnorances;
        Map<QName, Property> currentPropertyIgnorancesByName = this.propertyIgnorancesByName(currentProperties);
        Map<QName, Property> nextPropertyIgnorancesByName = this.propertyIgnorancesByName(nextProperties);
        Set<Property> currentPropertiesWithoutIgnorances = StoryChildElementsMerger.propertiesWithoutIgnorances(currentProperties, currentPropertyIgnorancesByName);
        return StoryChildElementsMerger.canPropertiesWithoutIgnorancesBeMerged(currentPropertiesWithoutIgnorances, nextAttributesWithoutIgnorances = StoryChildElementsMerger.propertiesWithoutIgnorances(nextProperties, nextPropertyIgnorancesByName)) && this.canPropertiesWithIgnorancesBeMerged(currentPropertyIgnorancesByName, nextPropertyIgnorancesByName);
    }

    private Map<QName, Property> propertyIgnorancesByName(Properties properties) {
        return properties.properties().stream().filter(property -> this.parameters.styleIgnorances().isPropertyNamePresent(property.getName())).collect(Collectors.toMap(Property::getName, Function.identity()));
    }

    private static Set<Property> propertiesWithoutIgnorances(Properties properties, Map<QName, Property> propertyIgnorancesByName) {
        return properties.properties().stream().filter(attribute -> !propertyIgnorancesByName.containsKey(attribute.getName())).collect(Collectors.toSet());
    }

    private static boolean canPropertiesWithoutIgnorancesBeMerged(Set<Property> currentPropertiesWithoutIgnorances, Set<Property> nextPropertiesWithoutIgnorances) {
        return currentPropertiesWithoutIgnorances.equals(nextPropertiesWithoutIgnorances);
    }

    private boolean canPropertiesWithIgnorancesBeMerged(Map<QName, Property> currentPropertyIgnorancesByName, Map<QName, Property> nextPropertyIgnorancesByName) {
        Set<QName> commonPropertyNameIgnorances = currentPropertyIgnorancesByName.keySet().stream().filter(nextPropertyIgnorancesByName::containsKey).collect(Collectors.toSet());
        return this.canCommonPropertyNameIgnorancesBeMerged(currentPropertyIgnorancesByName, nextPropertyIgnorancesByName, commonPropertyNameIgnorances) && this.canDistinctPropertyNameIgnorancesBeMerged(currentPropertyIgnorancesByName, commonPropertyNameIgnorances) && this.canDistinctPropertyNameIgnorancesBeMerged(nextPropertyIgnorancesByName, commonPropertyNameIgnorances);
    }

    private boolean canCommonPropertyNameIgnorancesBeMerged(Map<QName, Property> currentPropertyIgnorancesByName, Map<QName, Property> nextPropertyIgnorancesByName, Set<QName> commonPropertyNameIgnorances) {
        for (QName name : commonPropertyNameIgnorances) {
            if (this.canInnerEventsBeIgnored(name, currentPropertyIgnorancesByName.get(name).innerEvents(), nextPropertyIgnorancesByName.get(name).innerEvents())) continue;
            return false;
        }
        return true;
    }

    private boolean canDistinctPropertyNameIgnorancesBeMerged(Map<QName, Property> propertyIgnorancesByName, Set<QName> commonPropertyNameIgnorances) {
        Set propertyNameIgnorances = propertyIgnorancesByName.keySet().stream().filter(name -> !commonPropertyNameIgnorances.contains(name)).collect(Collectors.toSet());
        for (QName name2 : propertyNameIgnorances) {
            if (this.parameters.styleIgnorances().thresholds(name2).areEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean canInnerEventsBeIgnored(QName name, List<XMLEvent> currentPropertyInnerEvents, List<XMLEvent> nextPropertyInnerEvents) {
        return this.canValuesBeIgnored(name, StoryChildElementsMerger.eventsToString(currentPropertyInnerEvents), StoryChildElementsMerger.eventsToString(nextPropertyInnerEvents));
    }

    private static String eventsToString(List<XMLEvent> events) {
        return events.stream().map(event -> event.asCharacters().getData()).collect(Collectors.joining());
    }

    private StoryChildElement mergeElements(StoryChildElement currentElement, StoryChildElement nextElement) {
        return new StoryChildElement.StyledTextElement.Content(currentElement.startElement(), StoryChildElementsMerger.mergeEvents(currentElement.innerEvents(), nextElement.innerEvents()), currentElement.endElement(), this.eventFactory, StoryChildElementsMerger.mergeStyleRanges(((StoryChildElement.StyledTextElement)currentElement).styleRanges(), ((StoryChildElement.StyledTextElement)nextElement).styleRanges()));
    }

    private static List<XMLEvent> mergeEvents(List<XMLEvent> currentEvents, List<XMLEvent> nextEvents) {
        return Stream.concat(currentEvents.stream(), nextEvents.stream()).collect(Collectors.toList());
    }

    private static List<StoryChildElement> mergeElementsStyleRanges(StoryChildElement currentElement, StoryChildElement nextElement) {
        return StoryChildElementsMerger.createElementsWithMergedStyleRanges(currentElement, nextElement, StoryChildElementsMerger.mergeStyleRanges(((StoryChildElement.StyledTextElement)currentElement).styleRanges(), ((StoryChildElement.StyledTextElement)nextElement).styleRanges()));
    }

    private static StyleRanges mergeStyleRanges(StyleRanges currentStyleRanges, StyleRanges nextStyleRanges) {
        return currentStyleRanges.amount() <= nextStyleRanges.amount() ? currentStyleRanges : nextStyleRanges;
    }

    private static List<StoryChildElement> createElementsWithMergedStyleRanges(StoryChildElement currentElement, StoryChildElement nextElement, StyleRanges styleRanges) {
        return Arrays.asList(((StoryChildElement.StyledTextElement)currentElement).copyWith(styleRanges), ((StoryChildElement.StyledTextElement)nextElement).copyWith(styleRanges));
    }
}

