/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleRange;
import net.sf.okapi.filters.idml.StyleRanges;

class StoryChildElementsWriter {
    private final List<QName> effectiveStyleRanges;
    private final List<XMLEvent> events;
    private StyleRanges currentStyleRanges;

    StoryChildElementsWriter(QName ... effectiveStyleRanges) {
        this(Arrays.asList(effectiveStyleRanges), new ArrayList<XMLEvent>());
    }

    StoryChildElementsWriter(List<QName> effectiveStyleRanges, List<XMLEvent> events) {
        this.effectiveStyleRanges = effectiveStyleRanges;
        this.events = events;
    }

    List<QName> effectiveStyleRanges() {
        return this.effectiveStyleRanges;
    }

    List<XMLEvent> write(List<StoryChildElement> storyChildElements) {
        this.events.clear();
        for (StoryChildElement storyChildElement : storyChildElements) {
            if (!(storyChildElement instanceof StoryChildElement.StyledTextElement)) {
                this.writeAsNonStyledTextElement(storyChildElement);
                continue;
            }
            this.writeAsStyledTextElement(storyChildElement);
        }
        return this.events;
    }

    private void writeAsNonStyledTextElement(StoryChildElement storyChildElement) {
        if (null != this.currentStyleRanges) {
            this.writeClosingStyleRanges();
        }
        this.events.addAll(storyChildElement.getEvents());
        if (null != this.currentStyleRanges) {
            this.writeOpeningStyleRanges();
        }
    }

    private void writeAsStyledTextElement(StoryChildElement storyChildElement) {
        StyleRanges styleRanges = ((StoryChildElement.StyledTextElement)storyChildElement).styleRanges();
        if (null == this.currentStyleRanges) {
            this.currentStyleRanges = styleRanges;
            this.writeOpeningStyleRanges();
        } else if (!this.currentStyleRanges.paragraphStyleRange().equals(styleRanges.paragraphStyleRange())) {
            this.writeClosingStyleRanges();
            this.currentStyleRanges = styleRanges;
            this.writeOpeningStyleRanges();
        } else if (!this.currentStyleRanges.characterStyleRange().equals(styleRanges.characterStyleRange())) {
            if (this.effectiveStyleRanges.contains(StyleRange.CHARACTER_STYLE_RANGE)) {
                this.events.addAll(this.currentStyleRanges.characterStyleRange().asStyleRangeEnd());
            }
            this.currentStyleRanges = styleRanges;
            if (this.effectiveStyleRanges.contains(StyleRange.CHARACTER_STYLE_RANGE)) {
                this.events.addAll(this.currentStyleRanges.characterStyleRange().asStyleRangeStart());
            }
        }
        this.events.addAll(storyChildElement.getEvents());
    }

    private void writeOpeningStyleRanges() {
        if (this.effectiveStyleRanges.contains(StyleRange.PARAGRAPH_STYLE_RANGE)) {
            this.events.addAll(this.currentStyleRanges.paragraphStyleRange().asStyleRangeStart());
        }
        if (this.effectiveStyleRanges.contains(StyleRange.CHARACTER_STYLE_RANGE)) {
            this.events.addAll(this.currentStyleRanges.characterStyleRange().asStyleRangeStart());
        }
    }

    private void writeClosingStyleRanges() {
        if (this.effectiveStyleRanges.contains(StyleRange.CHARACTER_STYLE_RANGE)) {
            this.events.addAll(this.currentStyleRanges.characterStyleRange().asStyleRangeEnd());
        }
        if (this.effectiveStyleRanges.contains(StyleRange.PARAGRAPH_STYLE_RANGE)) {
            this.events.addAll(this.currentStyleRanges.paragraphStyleRange().asStyleRangeEnd());
        }
    }
}

