/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.Map;
import javax.xml.namespace.QName;
import net.sf.okapi.filters.idml.Namespaces;

class StyleIgnorances {
    private final Map<AttributeName, Thresholds> attributes;
    private final Map<PropertyName, Thresholds> properties;

    StyleIgnorances(Map<AttributeName, Thresholds> attributes, Map<PropertyName, Thresholds> properties) {
        this.attributes = attributes;
        this.properties = properties;
    }

    boolean isAttributeNamePresent(QName name) {
        return this.attributes.containsKey((Object)AttributeName.fromQName(name));
    }

    void putAttribute(AttributeName attributeName, Thresholds thresholds) {
        this.attributes.put(attributeName, thresholds);
    }

    void removeAttribute(AttributeName attributeName) {
        this.attributes.remove((Object)attributeName);
    }

    boolean isPropertyNamePresent(QName name) {
        return this.properties.containsKey((Object)PropertyName.fromQName(name));
    }

    void putProperty(PropertyName propertyName, Thresholds thresholds) {
        this.properties.put(propertyName, thresholds);
    }

    void removeProperty(PropertyName propertyName) {
        this.properties.remove((Object)propertyName);
    }

    Thresholds thresholds(QName name) {
        if (this.isAttributeNamePresent(name)) {
            return this.attributes.get((Object)AttributeName.fromQName(name));
        }
        if (this.isPropertyNamePresent(name)) {
            return this.properties.get((Object)PropertyName.fromQName(name));
        }
        return Thresholds.empty();
    }

    static enum AttributeName {
        KERNING_METHOD("KerningMethod"),
        KERNING_VALUE("KerningValue"),
        TRACKING("Tracking"),
        BASELINE_SHIFT("BaselineShift"),
        UNSUPPORTED("");

        private final QName value;

        private AttributeName(String value) {
            this.value = Namespaces.getDefaultNamespace().getQName(value);
        }

        static AttributeName fromQName(QName value) {
            for (AttributeName attributeName : AttributeName.values()) {
                if (!attributeName.toQName().equals(value)) continue;
                return attributeName;
            }
            return UNSUPPORTED;
        }

        QName toQName() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    static enum PropertyName {
        LEADING("Leading"),
        UNSUPPORTED("");

        private final QName value;

        private PropertyName(String value) {
            this.value = Namespaces.getDefaultNamespace().getQName(value);
        }

        static PropertyName fromQName(QName value) {
            for (PropertyName propertyName : PropertyName.values()) {
                if (!propertyName.toQName().equals(value)) continue;
                return propertyName;
            }
            return UNSUPPORTED;
        }

        QName toQName() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    static class Thresholds {
        private static final Type DEFAULT_TYPE = Type.STRING;
        private static final String DEFAULT_MIN = "";
        private static final String DEFAULT_MAX = "";
        private final Type type;
        private final String min;
        private final String max;

        static Thresholds empty() {
            return new Thresholds(DEFAULT_TYPE, "", "");
        }

        Thresholds(Type type, String min, String max) {
            this.type = type;
            this.min = min;
            this.max = max;
        }

        Type type() {
            return this.type;
        }

        String min() {
            return this.min;
        }

        String max() {
            return this.max;
        }

        boolean areEmpty() {
            return DEFAULT_TYPE == this.type && "".equals(this.min) && "".equals(this.max);
        }

        static enum Type {
            INTEGER("Integer"),
            DOUBLE("Double"),
            STRING("String");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            public String toString() {
                return this.value;
            }
        }
    }
}

