/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.Property;
import net.sf.okapi.filters.idml.StyleRange;

final class StyleRanges
implements MarkupRange {
    private final StyleRange paragraphStyleRange;
    private final StyleRange characterStyleRange;
    private StyleRange combinedStyleRange;

    StyleRanges(StyleRange paragraphStyleRange, StyleRange characterStyleRange) {
        this.paragraphStyleRange = paragraphStyleRange;
        this.characterStyleRange = characterStyleRange;
    }

    static StyleRanges defaultStyleRanges(XMLEventFactory eventFactory) {
        return new StyleRanges(StyleRange.defaultParagraphStyleRange(eventFactory), StyleRange.defaultCharacterStyleRange(eventFactory));
    }

    StyleRange paragraphStyleRange() {
        return this.paragraphStyleRange;
    }

    StyleRange characterStyleRange() {
        return this.characterStyleRange;
    }

    StyleRange combinedStyleRange() {
        if (Objects.isNull(this.combinedStyleRange)) {
            StyleRange.StyleRangeBuilder styleRangeBuilder = new StyleRange.StyleRangeBuilder(this.characterStyleRange.eventFactory(), new StyleRange.AttributesComparator());
            styleRangeBuilder.setName(this.characterStyleRange.name());
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.addAll(this.paragraphStyleRange.attributes());
            attributes.addAll(this.characterStyleRange.attributes());
            styleRangeBuilder.setAttributes(attributes);
            ArrayList<Property> properties = new ArrayList<Property>(this.paragraphStyleRange.properties().properties());
            properties.addAll(this.characterStyleRange.properties().properties());
            Properties.Builder propertiesBuilder = new Properties.Builder(new Properties.Comparator());
            propertiesBuilder.setStartElement(this.characterStyleRange.properties().startElement()).setEndElement(this.characterStyleRange.properties().endElement()).addProperties(properties);
            this.combinedStyleRange = styleRangeBuilder.setProperties(propertiesBuilder.build()).build();
        }
        return this.combinedStyleRange;
    }

    boolean isSubsetOf(StyleRanges other) {
        return this.paragraphStyleRange().isSubsetOf(other.paragraphStyleRange()) && this.characterStyleRange().isSubsetOf(other.characterStyleRange());
    }

    int amount() {
        return this.paragraphStyleRange.attributes().size() + this.paragraphStyleRange.properties().properties().size() + this.characterStyleRange.attributes().size() + this.characterStyleRange.properties().properties().size();
    }

    @Override
    public void apply(FontMappings fontMappings) {
        this.paragraphStyleRange.apply(fontMappings);
        this.characterStyleRange.apply(fontMappings);
    }

    StyleRanges mergedWith(StyleRanges styleRanges) {
        return new StyleRanges(this.paragraphStyleRange.mergedWith(styleRanges.paragraphStyleRange()), this.characterStyleRange.mergedWith(styleRanges.characterStyleRange()));
    }

    @Override
    public List<XMLEvent> getEvents() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        StyleRanges that = (StyleRanges)o;
        return Objects.equals(this.paragraphStyleRange(), that.paragraphStyleRange()) && Objects.equals(this.characterStyleRange(), that.characterStyleRange());
    }

    public int hashCode() {
        return Objects.hash(this.paragraphStyleRange(), this.characterStyleRange());
    }
}

