/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.SpecialCharacter;
import net.sf.okapi.filters.idml.TextSkeleton;

final class TextSkeletonMerging {
    private static final String UNEXPECTED_CODE = "Unexpected code";
    private final XMLEventFactory eventFactory;
    private final LocaleId targetLocale;
    private Element textElement;
    private Map<Integer, Object> codeMap;
    private StringBuilder contentTextBuilder;
    private List<XMLEvent> contentEvents;

    TextSkeletonMerging(XMLEventFactory eventFactory, LocaleId targetLocale) {
        this.eventFactory = eventFactory;
        this.targetLocale = targetLocale;
    }

    void performFor(ITextUnit textUnit) {
        TextContainer tc = null == textUnit.getTarget(this.targetLocale) ? textUnit.getSource() : textUnit.getTarget(this.targetLocale);
        TextSkeleton ts = (TextSkeleton)textUnit.getSkeleton();
        this.textElement = ts.element();
        if (TextSkeleton.DEFAULT_ATTRIBUTE_NAME.equals(ts.attributeName())) {
            this.codeMap = ts.codeMap();
            this.contentTextBuilder = new StringBuilder();
            this.contentEvents = new LinkedList<XMLEvent>();
            this.mergeCodesIn(tc);
            this.updateTextElementInnerEvents();
        } else {
            TextSkeleton nts = new TextSkeleton(this.updatedTextElementWith(ts.attributeName(), tc.getUnSegmentedContentCopy()), ts.codeMap(), ts.attributeName());
            nts.setParent(ts.getParent());
            textUnit.setSkeleton(nts);
        }
    }

    private void mergeCodesIn(TextContainer textContainer) {
        for (Segment segment : textContainer.getSegments()) {
            this.mergeCodesIn(segment);
        }
    }

    private void mergeCodesIn(Segment segment) {
        String codedText = segment.getContent().getCodedText();
        List<Code> codes = segment.getContent().getCodes();
        for (int i = 0; i < codedText.length(); ++i) {
            char c = codedText.charAt(i);
            if (!TextFragment.isMarker(c)) {
                this.addChar(c);
                continue;
            }
            int codeIndex = TextFragment.toIndex(codedText.charAt(++i));
            this.addCode(codes.get(codeIndex));
        }
    }

    private void addChar(char c) {
        this.contentTextBuilder.append(c);
    }

    private void addCode(Code code) {
        Object object = this.codeMap.get(code.getId());
        if (object instanceof String) {
            this.contentTextBuilder.append(object);
        } else if (object instanceof SpecialCharacter) {
            this.addSpecialCharacter((SpecialCharacter)object);
        } else {
            throw new IllegalStateException(UNEXPECTED_CODE + String.valueOf(object));
        }
    }

    private void addSpecialCharacter(SpecialCharacter specialCharacter) {
        if (!(specialCharacter instanceof SpecialCharacter.Instruction)) {
            this.contentTextBuilder.append(specialCharacter.event().asCharacters().getData());
            return;
        }
        if (0 < this.contentTextBuilder.length()) {
            this.contentEvents.add(this.eventFactory.createCharacters(this.contentTextBuilder.toString()));
            this.contentTextBuilder = new StringBuilder();
        }
        this.contentEvents.addAll(specialCharacter.getEvents());
    }

    private void updateTextElementInnerEvents() {
        if (this.contentEvents.isEmpty() && 0 == this.contentTextBuilder.length()) {
            return;
        }
        if (0 < this.contentTextBuilder.length()) {
            this.contentEvents.add(this.eventFactory.createCharacters(this.contentTextBuilder.toString()));
        }
        if (!this.contentEvents.isEmpty()) {
            this.textElement.updateInnerEventsWith(this.contentEvents);
        }
    }

    private Element updatedTextElementWith(QName attributeName, TextFragment textFragment) {
        Attribute na = this.eventFactory.createAttribute(attributeName, textFragment.getText());
        LinkedList attributes = new LinkedList();
        this.textElement.startElement().getAttributes().forEachRemaining(a -> {
            if (a.getName().equals(na.getName())) {
                attributes.add(na);
            } else {
                attributes.add(a);
            }
        });
        return new Element.Default(this.eventFactory.createStartElement(this.textElement.getName(), attributes.iterator(), Collections.emptyListIterator()), this.textElement.innerEvents(), this.textElement.endElement(), this.eventFactory);
    }
}

