/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.its;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.okapi.common.DefaultEntityResolver;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.its.NSContextManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Parameters
implements IParameters,
ISimplifierRulesParameters {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PROTECTENTITYREF = "protectEntityRef";
    private static final String LINEBREAKASCODE = "lineBreakAsCode";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String OMITXMLDECLARATION = "omitXMLDeclaration";
    private static final String ESCAPEQUOTES = "escapeQuotes";
    private static final String ANDROIDQUOTES = "androidQuotes";
    private static final String EXTRACTIFONLYCODES = "extractIfOnlyCodes";
    private static final String MAPANNOTATIONS = "mapAnnotations";
    private static final String INLINECDATA = "inlineCdata";
    private static final String EXTRACT_UNTRANSLATABLE = "extractUntranslatable";
    private static final String CDATASUBFILTER = "cdataSubfilter";
    private static final String OVERWRITECODESWITHDISPLAYTEXT = "overwriteCodesWithDisplayText";
    private static final String STRIPCOMMENTSWITHINTEXT = "stripCommentsWithinText";
    private static final String OKP_NS_PREFIX = "okp";
    private static final String OKP_NS_URI = "okapi-framework:xmlfilter-options";
    static final String DEFAULTS = "<?xml version='1.0' ?>\n<its:rules version='1.0'\n xmlns:its='http://www.w3.org/2005/11/its'\n xmlns:xlink='http://www.w3.org/1999/xlink'\n xmlns:itsx='http://www.w3.org/2008/12/its-extensions'\n xmlns:okp='okapi-framework:xmlfilter-options'\n>\n<!-- See ITS specification at: http://www.w3.org/TR/its/ -->\n</its:rules>\n";
    private String path;
    private URI docURI;
    private Document doc;
    private final DocumentBuilder docBuilder;
    private final XPath xpath;
    public boolean useCodeFinder;
    public InlineCodeFinder codeFinder;
    public Boolean moveLeadingAndTrailingCodesToSkeleton;
    public Boolean mergeAdjacentCodes;
    public String simplifierRules;
    public boolean escapeGT;
    public boolean escapeNbsp;
    public boolean protectEntityRef;
    public boolean escapeLineBreak;
    public boolean lineBreakAsCode;
    public boolean omitXMLDeclaration;
    public boolean escapeQuotes;
    public boolean androidQuotes;
    public boolean extractIfOnlyCodes;
    public boolean mapAnnotations;
    public boolean inlineCdata;
    public boolean extractUntranslatable;
    public boolean quoteModeDefined;
    public int quoteMode;
    public String cdataSubfilter;
    public boolean overwriteCodesWithDisplayText;
    public boolean stripCommentsWithinText;

    public Parameters() {
        this.reset();
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        fact.setValidating(false);
        try {
            fact.setFeature("http://xml.org/sax/features/external-general-entities", false);
            fact.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            this.logger.warn("Unsupported DocumentBuilderFactory feature. Possible security vulnerabilities.", (Throwable)e);
        }
        try {
            this.docBuilder = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OkapiIOException(e);
        }
        this.docBuilder.setEntityResolver(new DefaultEntityResolver());
        XPathFactory xpFact = Util.createXPathFactory();
        this.xpath = xpFact.newXPath();
        NSContextManager nsContext = new NSContextManager();
        nsContext.addNamespace(OKP_NS_PREFIX, OKP_NS_URI);
        this.xpath.setNamespaceContext(nsContext);
    }

    @Override
    public String toString() {
        if (this.doc == null) {
            return DEFAULTS;
        }
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(new DOMSource(this.doc), result);
        }
        catch (TransformerException e) {
            throw new OkapiIOException(e);
        }
        return sw.toString();
    }

    @Override
    public void fromString(String data) {
        this.docURI = null;
        this.path = null;
        try {
            this.doc = this.docBuilder.parse(new InputSource(new StringReader(data)));
            this.getFilterOptions();
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String filePath) {
        this.path = filePath;
    }

    @Override
    public void load(URL inputURL, boolean ignoreErrors) {
        try {
            String tmp = inputURL.toString();
            this.doc = tmp.startsWith("jar:") ? this.docBuilder.parse(inputURL.openStream()) : this.docBuilder.parse(inputURL.toURI().toString());
            this.path = inputURL.toURI().getPath();
            this.docURI = inputURL.toURI();
            this.getFilterOptions();
        }
        catch (IOException | URISyntaxException | XPathExpressionException | SAXException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void load(InputStream inStream, boolean ignoreErrors) {
        try {
            this.doc = this.docBuilder.parse(inStream);
            this.getFilterOptions();
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void reset() {
        this.doc = null;
        this.docURI = null;
        this.useCodeFinder = false;
        this.codeFinder = new InlineCodeFinder();
        this.moveLeadingAndTrailingCodesToSkeleton = null;
        this.mergeAdjacentCodes = null;
        this.simplifierRules = null;
        this.codeFinder.reset();
        this.escapeGT = true;
        this.escapeNbsp = true;
        this.protectEntityRef = true;
        this.escapeLineBreak = false;
        this.lineBreakAsCode = false;
        this.omitXMLDeclaration = false;
        this.quoteModeDefined = true;
        this.quoteMode = 3;
        this.escapeQuotes = true;
        this.androidQuotes = false;
        this.extractIfOnlyCodes = true;
        this.mapAnnotations = true;
        this.inlineCdata = false;
        this.extractUntranslatable = false;
        this.cdataSubfilter = null;
        this.overwriteCodesWithDisplayText = false;
        this.stripCommentsWithinText = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String filePath) {
        StreamResult result = null;
        Transformer trans = null;
        try {
            if (this.doc == null) {
                this.fromString(DEFAULTS);
            }
            File f = new File(filePath);
            result = new StreamResult(f);
            try {
                trans = TransformerFactory.newInstance().newTransformer();
                trans.transform(new DOMSource(this.doc), result);
            }
            catch (TransformerException e) {
                throw new OkapiIOException(e);
            }
            this.path = filePath;
            this.docURI = f.toURI();
        }
        finally {
            trans = null;
            result = null;
            System.gc();
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public URI getURI() {
        return this.docURI;
    }

    @Override
    public boolean getBoolean(String name) {
        if (name.equals("escapeGT")) {
            return this.escapeGT;
        }
        if (name.equals("escapeNbsp")) {
            return this.escapeNbsp;
        }
        if (name.equals(PROTECTENTITYREF)) {
            return this.protectEntityRef;
        }
        if (name.equals("escapeLineBreak")) {
            return this.escapeLineBreak;
        }
        if (name.equals(LINEBREAKASCODE)) {
            return this.lineBreakAsCode;
        }
        if (name.equals(OMITXMLDECLARATION)) {
            return this.omitXMLDeclaration;
        }
        if (name.equals("quoteModeDefined")) {
            return this.quoteModeDefined;
        }
        if (name.equals(ESCAPEQUOTES)) {
            return this.escapeQuotes;
        }
        if (name.equals(ANDROIDQUOTES)) {
            return this.androidQuotes;
        }
        if (name.equals(EXTRACTIFONLYCODES)) {
            return this.extractIfOnlyCodes;
        }
        if (name.equals(MAPANNOTATIONS)) {
            return this.mapAnnotations;
        }
        if (name.equals(INLINECDATA)) {
            return this.inlineCdata;
        }
        if (name.equals(EXTRACT_UNTRANSLATABLE)) {
            return this.extractUntranslatable;
        }
        if (name.equals(OVERWRITECODESWITHDISPLAYTEXT)) {
            return this.overwriteCodesWithDisplayText;
        }
        if (name.equals(STRIPCOMMENTSWITHINTEXT)) {
            return this.stripCommentsWithinText;
        }
        return false;
    }

    @Override
    public void setBoolean(String name, boolean value) {
        switch (name) {
            case "escapeGT": {
                this.escapeGT = value;
                break;
            }
            case "escapeNbsp": {
                this.escapeNbsp = value;
                break;
            }
            case "protectEntityRef": {
                this.protectEntityRef = value;
                break;
            }
            case "escapeLineBreak": {
                this.escapeLineBreak = value;
                break;
            }
            case "lineBreakAsCode": {
                this.lineBreakAsCode = value;
                break;
            }
            case "omitXMLDeclaration": {
                this.omitXMLDeclaration = value;
                break;
            }
            case "quoteModeDefined": {
                this.quoteModeDefined = value;
                break;
            }
            case "escapeQuotes": {
                this.escapeQuotes = value;
                break;
            }
            case "androidQuotes": {
                this.androidQuotes = value;
                break;
            }
            case "extractIfOnlyCodes": {
                this.extractIfOnlyCodes = value;
                break;
            }
            case "mapAnnotations": {
                this.mapAnnotations = value;
                break;
            }
            case "inlineCdata": {
                this.inlineCdata = value;
                break;
            }
            case "extractUntranslatable": {
                this.extractUntranslatable = value;
                break;
            }
            case "overwriteCodesWithDisplayText": {
                this.overwriteCodesWithDisplayText = value;
                break;
            }
            case "stripCommentsWithinText": {
                this.stripCommentsWithinText = value;
            }
        }
    }

    @Override
    public String getString(String name) {
        if (name.equals(CDATASUBFILTER)) {
            return this.cdataSubfilter;
        }
        return null;
    }

    @Override
    public void setString(String name, String value) {
        switch (name) {
            case "cdataSubfilter": {
                this.cdataSubfilter = value;
            }
        }
    }

    @Override
    public int getInteger(String name) {
        if (name.equals("quoteMode")) {
            return this.quoteMode;
        }
        return 0;
    }

    @Override
    public void setInteger(String name, int value) {
        if (name.equals("quoteMode")) {
            this.quoteMode = value;
        }
    }

    @Override
    public ParametersDescription getParametersDescription() {
        return null;
    }

    private void getFilterOptions() throws XPathExpressionException {
        String tmp;
        Element elem;
        NodeList nl = (NodeList)this.xpath.evaluate("//okp:options", this.doc, XPathConstants.NODESET);
        if (nl.getLength() > 0) {
            elem = (Element)nl.item(0);
            tmp = elem.getAttribute("escapeLineBreak");
            if (!Util.isEmpty(tmp)) {
                this.escapeLineBreak = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute("escapeNbsp"))) {
                this.escapeNbsp = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(LINEBREAKASCODE))) {
                this.lineBreakAsCode = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute("escapeGT"))) {
                this.escapeGT = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(ESCAPEQUOTES))) {
                this.escapeQuotes = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(ANDROIDQUOTES))) {
                this.androidQuotes = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(EXTRACTIFONLYCODES))) {
                this.extractIfOnlyCodes = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(PROTECTENTITYREF))) {
                this.protectEntityRef = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(OMITXMLDECLARATION))) {
                this.omitXMLDeclaration = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(MAPANNOTATIONS))) {
                this.mapAnnotations = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(INLINECDATA))) {
                this.inlineCdata = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(EXTRACT_UNTRANSLATABLE))) {
                this.extractUntranslatable = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(CDATASUBFILTER))) {
                this.cdataSubfilter = tmp;
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(OVERWRITECODESWITHDISPLAYTEXT))) {
                this.overwriteCodesWithDisplayText = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(STRIPCOMMENTSWITHINTEXT))) {
                this.stripCommentsWithinText = tmp.equals("yes");
            }
        }
        if ((nl = (NodeList)this.xpath.evaluate("//okp:codeFinder", this.doc, XPathConstants.NODESET)).getLength() > 0) {
            elem = (Element)nl.item(0);
            tmp = elem.getAttribute(USECODEFINDER);
            if (!Util.isEmpty(tmp)) {
                this.useCodeFinder = tmp.equals("yes");
            }
            if ((tmp = Util.getTextContent(elem)) == null) {
                tmp = "";
            }
            this.codeFinder.fromString(tmp);
        }
        if ((nl = (NodeList)this.xpath.evaluate("//okp:simplifierRules", this.doc, XPathConstants.NODESET)).getLength() > 0) {
            String mergeValue;
            Element e = (Element)nl.item(0);
            String moveValue = e.getAttribute("moveLeadingAndTrailingCodesToSkeleton");
            if (!Util.isEmpty(moveValue)) {
                this.moveLeadingAndTrailingCodesToSkeleton = moveValue.equals("yes");
            }
            if (!Util.isEmpty(mergeValue = e.getAttribute("mergeAdjacentCodes"))) {
                this.mergeAdjacentCodes = mergeValue.equals("yes");
            }
            this.simplifierRules = Util.getTextContent(e).strip();
        }
    }

    @Override
    public Optional<Boolean> getMoveLeadingAndTrailingCodesToSkeleton() {
        return Optional.ofNullable(this.moveLeadingAndTrailingCodesToSkeleton);
    }

    @Override
    public Optional<Boolean> getMergeAdjacentCodes() {
        return Optional.ofNullable(this.mergeAdjacentCodes);
    }

    @Override
    public String getSimplifierRules() {
        return this.simplifierRules;
    }

    @Override
    public void setSimplifierRules(String simplifierRules) {
        this.simplifierRules = simplifierRules;
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }
}

