/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.filters.markdown.MarkdownLinePrefixAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownSkeletonWriter
extends GenericSkeletonWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Pattern linePat = Pattern.compile("[^\r\n]*(\r\n|\n|\r)");
    String linePrefix = "";
    boolean lineCompleted = true;

    @Override
    public String processTextUnit(ITextUnit resource) {
        this.obtainLinePrefix(resource);
        return this.appendLinePrefix(super.processTextUnit(resource));
    }

    @Override
    public String processDocumentPart(DocumentPart resource) {
        this.obtainLinePrefix(resource);
        return this.appendLinePrefix(super.processDocumentPart(resource));
    }

    @Override
    public String processEndSubfilter(EndSubfilter resource) {
        return this.appendLinePrefix(super.processEndSubfilter(resource));
    }

    private void obtainLinePrefix(IWithAnnotations resource) {
        MarkdownLinePrefixAnnotation lpa = resource.getAnnotation(MarkdownLinePrefixAnnotation.class);
        if (lpa != null) {
            this.linePrefix = lpa.getLinePrefix();
        }
    }

    String appendLinePrefix(String content) {
        if (content.isEmpty()) {
            return "";
        }
        Matcher m = linePat.matcher(content);
        StringBuilder sb = new StringBuilder();
        int lastHitEnd = 0;
        boolean hadNewline = false;
        if (this.lineCompleted) {
            sb.append(this.linePrefix);
        }
        while (m.find()) {
            if (hadNewline) {
                sb.append(this.linePrefix);
            }
            sb.append(m.group());
            lastHitEnd = m.end();
            hadNewline = true;
        }
        boolean bl = this.lineCompleted = lastHitEnd == content.length();
        if (!this.lineCompleted) {
            if (hadNewline) {
                sb.append(this.linePrefix);
            }
            sb.append(content.substring(lastHitEnd));
        }
        return sb.toString();
    }

    @Override
    protected boolean isCodeThatDisablesEncoding(Code code) {
        return super.isCodeThatDisablesEncoding(code) || code.getType().equals("CODE");
    }
}

