/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import net.sf.okapi.common.resource.CodeSimplifier;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.SkeletonUtil;

interface TextUnitSimplification {
    public void applyTo(ITextUnit var1);

    public static class Default
    implements TextUnitSimplification {
        private final CodeSimplifier codeSimplifier;

        public Default(CodeSimplifier codeSimplifier) {
            this.codeSimplifier = codeSimplifier;
        }

        @Override
        public void applyTo(ITextUnit textUnit) {
            TextFragment tf = textUnit.getSource().getUnSegmentedContentCopy();
            TextFragment[] res = this.codeSimplifier.simplifyAll(tf, true, true);
            textUnit.setSourceContent(tf);
            if (null != res) {
                GenericSkeleton original = TextUnitUtil.forceSkeleton(textUnit);
                GenericSkeleton adjusted = new GenericSkeleton();
                adjusted.add(Default.textFragmentAsString(res[0]));
                adjusted.addContentPlaceholder(textUnit);
                adjusted.add(Default.textFragmentAsString(res[1]));
                int index = SkeletonUtil.findTuRefInSkeleton(original);
                if (index != -1) {
                    SkeletonUtil.replaceSkeletonPart(original, index, adjusted);
                } else {
                    original.add(adjusted);
                }
            }
        }

        private static String textFragmentAsString(TextFragment textFragment) {
            String s = textFragment == null || textFragment.isEmpty() ? "" : TextFragmentUtil.toText(textFragment);
            return s;
        }
    }
}

