/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.CodeTypeFactory;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunCode;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunPropertiesPairWithDetectedRunFonts;
import net.sf.okapi.filters.openxml.StyledTextMapping;
import net.sf.okapi.filters.openxml.TextUnitProperties;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.TranslatableAttributeText;
import net.sf.okapi.filters.openxml.XMLEvents;

class BlockMapping
extends StyledTextMapping {
    private final Block block;

    BlockMapping(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, IdGenerator idGenerator, Block block) {
        super(conditionalParameters, eventFactory, idGenerator);
        this.block = block;
    }

    @Override
    public List<ITextUnit> textUnits() {
        TextUnit textUnit;
        if (this.block.getChunks().size() <= 2) {
            for (XMLEvents xMLEvents : this.block.getChunks()) {
                if (!(xMLEvents instanceof Run)) continue;
                throw new IllegalStateException("Unexpected structure");
            }
            return Collections.emptyList();
        }
        if (this.block.referenceId().isEmpty()) {
            textUnit = new TextUnit(this.ids.createId());
        } else {
            long l = Long.parseLong(this.block.referenceId()) - 1L;
            this.ids.setSequence(l);
            textUnit = new TextUnit(this.ids.createId());
        }
        textUnit.setPreserveWhitespaces(true);
        TextFragment textFragment = new TextFragment();
        textUnit.setSource(new TextContainer(textFragment));
        List<Chunk> chunks = this.block.getChunks().subList(1, this.block.getChunks().size() - 1);
        this.baseRunPropertiesPairWithDetectedRunFonts(chunks, this.block.name());
        boolean runHasText = false;
        for (Chunk chunk : chunks) {
            if (chunk instanceof Run) {
                runHasText |= this.processRun(textUnit, (Run)chunk);
                continue;
            }
            if (chunk instanceof RunContainer) {
                RunContainer rc = (RunContainer)chunk;
                if (rc.getChunks().isEmpty()) {
                    this.addIsolatedCode(textFragment, chunk);
                    continue;
                }
                Code openCode = this.addOpeningCode(textFragment, rc);
                int savedFormattingCodeDepth = this.runCodeStack.size();
                for (int nestedRunPosition = 0; nestedRunPosition < rc.getChunks().size(); ++nestedRunPosition) {
                    if (rc.getChunks().get(nestedRunPosition) instanceof Run) {
                        runHasText |= this.processNestedRun(textFragment, rc.getChunks(), textUnit, nestedRunPosition, savedFormattingCodeDepth);
                        continue;
                    }
                    if (rc.getChunks().get(nestedRunPosition) instanceof RunContainer) {
                        RunContainer nestedRunContainer = (RunContainer)rc.getChunks().get(nestedRunPosition);
                        runHasText |= this.processNestedRunContainer(textFragment, nestedRunContainer, textUnit);
                        continue;
                    }
                    throw new OkapiException("Wrong type of node");
                }
                this.popRunCodesToDepth(textFragment, savedFormattingCodeDepth);
                this.addClosingCode(textFragment, rc, openCode);
                continue;
            }
            if (textFragment.getCodedText().isEmpty()) {
                this.leadingCodes.add(chunk);
                continue;
            }
            this.addIsolatedCode(textFragment, chunk);
        }
        this.popAllRunCodes(textFragment);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>(this.referentTus.size() + 1);
        if (runHasText || !this.referentTus.isEmpty()) {
            this.applyCodeFindingTo(textFragment);
            BlockSkeleton skel = new BlockSkeleton(this.block, this.baseRunPropertiesPairWithDetectedRunFonts, this.leadingCodes, this.codes);
            skel.setParent(textUnit);
            textUnit.setSkeleton(skel);
            tus.add(textUnit);
        }
        tus.addAll(this.referentTus);
        return tus;
    }

    private boolean processNestedRunContainer(TextFragment tf, RunContainer rc, ITextUnit textUnit) {
        boolean runHasText = false;
        Code openNestedCode = this.addOpeningCode(tf, rc);
        int savedFormattingNestedCodeDepth = this.runCodeStack.size();
        for (int i = 0; i < rc.getChunks().size(); ++i) {
            Chunk chunk = rc.getChunks().get(i);
            if (chunk instanceof Run) {
                runHasText |= this.processNestedRun(tf, rc.getChunks(), textUnit, i, savedFormattingNestedCodeDepth);
                continue;
            }
            if (!(chunk instanceof RunContainer)) continue;
            runHasText |= this.processNestedRunContainer(tf, (RunContainer)chunk, textUnit);
        }
        this.popRunCodesToDepth(tf, savedFormattingNestedCodeDepth);
        this.addClosingCode(tf, rc, openNestedCode);
        return runHasText;
    }

    private boolean processNestedRun(TextFragment tf, List<Chunk> chunks, ITextUnit textUnit, int runPosition, int codeStackPopsLimit) {
        List<ITextUnit> nestedTus = this.processNestedBlocks((Run)chunks.get(runPosition), textUnit.getId());
        TextUnitProperties.addInteger(textUnit, "references", this.countDirectReferences(nestedTus));
        this.referentTus.addAll(nestedTus);
        Run run = (Run)chunks.get(runPosition);
        int nextRunPosition = runPosition + 1;
        Run nextRun = nextRunPosition < chunks.size() && chunks.get(nextRunPosition) instanceof Run ? (Run)chunks.get(nextRunPosition) : null;
        return this.addRun(tf, codeStackPopsLimit, runPosition, run, nextRun);
    }

    @Override
    protected List<ITextUnit> processNestedBlocks(Run run, String parentId) {
        IdGenerator nestedIds = this.nestedIdsFor(parentId);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>();
        for (Textual textual : run.getNestedTextualItems()) {
            if (textual instanceof Block) {
                BlockMapping nestedMapping = new BlockMapping(this.conditionalParameters, this.eventFactory, nestedIds, (Block)textual);
                List<ITextUnit> nestedTus = nestedMapping.textUnits();
                for (ITextUnit tu : nestedTus) {
                    if (!Objects.isNull(tu.getParentId())) continue;
                    tu.setIsReferent(true);
                    tu.setParentId(parentId);
                }
                tus.addAll(nestedTus);
                continue;
            }
            if (!(textual instanceof TranslatableAttributeText)) continue;
            tus.add(this.textUnitFor((TranslatableAttributeText)textual, parentId, nestedIds));
        }
        return tus;
    }

    private void popRunCodesToDepth(TextFragment tf, int desiredDepth) {
        while (this.runCodeStack.size() > desiredDepth) {
            this.addClosingCode(tf, (RunCode)this.runCodeStack.pop());
        }
    }

    private Code addOpeningCode(TextFragment tf, RunContainer rc) {
        Code code = new Code(TextFragment.TagType.OPENING, CodeTypeFactory.createCodeType(rc));
        code.setData("<" + rc.type().value() + this.nextCodeId + ">");
        code.setId(this.nextCodeId);
        tf.append(code);
        this.codes.put(this.nextCodeId, rc);
        RunPropertiesPairWithDetectedRunFonts rpp = rc.defaultRunPropertiesPairWithDetectedRunFonts();
        this.runCodeStack.push(new RunCode(this.nextCodeId++, CodeTypeFactory.createCodeType(rpp.combined()), rpp));
        return code;
    }

    private void addClosingCode(TextFragment tf, RunContainer rc, Code openCode) {
        Code code = new Code(TextFragment.TagType.CLOSING, openCode.getType());
        code.setData("</" + rc.type().value() + openCode.getId() + ">");
        code.setId(openCode.getId());
        this.runCodeStack.pop();
        tf.append(code);
    }
}

